/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionMap;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;

public class CollectionMapSerializationModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    CollectionMapSerializationModule() {
        this.addSerializer(CollectionMap.class, new CollectionMapSerializer());
        this.addDeserializer(ListMap.class, ListMapDeserializer.create());
        this.addDeserializer(SetMap.class, SetMapDeserializer.create());
    }

    private static class CollectionMapSerializer<K, V, C extends Collection<V>>
    extends JsonSerializer<CollectionMap<K, V, C>> {
        private CollectionMapSerializer() {
        }

        public void serialize(CollectionMap<K, V, C> value, JsonGenerator generator, SerializerProvider serializers) throws IOException {
            HashMap map = new HashMap();
            for (Map.Entry entry : value.entrySet()) {
                map.put(entry.getKey(), (Collection)entry.getValue());
            }
            generator.writeObject(map);
        }
    }

    private static class ListMapDeserializer<K, V>
    extends CollectionMapDeserializerBase<K, V, List<V>>
    implements ContextualDeserializer {
        private ListMapDeserializer(JavaType keyType, JavaType valueType) {
            super(keyType, valueType);
        }

        public static ListMapDeserializer create() {
            return new ListMapDeserializer(null, null);
        }

        public ListMap<K, V> deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
            TypeFactory typeFactory = ctx.getTypeFactory();
            CollectionLikeType listType = typeFactory.constructCollectionLikeType(List.class, this.valueType);
            MapLikeType mapType = typeFactory.constructMapLikeType(Map.class, this.keyType, (JavaType)listType);
            HashMap root = (HashMap)ctx.readValue(parser, (JavaType)mapType);
            return new ListMap((Map)root);
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            JavaType listMapType = CollectionMapDeserializerBase.getPropertyType(ctxt, property);
            return new ListMapDeserializer<K, V>(listMapType.containedType(0), listMapType.containedType(1));
        }
    }

    private static class SetMapDeserializer<K, V>
    extends CollectionMapDeserializerBase<K, V, Set<V>>
    implements ContextualDeserializer {
        private SetMapDeserializer(JavaType keyType, JavaType valueType) {
            super(keyType, valueType);
        }

        public static SetMapDeserializer create() {
            return new SetMapDeserializer(null, null);
        }

        public SetMap<K, V> deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
            TypeFactory typeFactory = ctx.getTypeFactory();
            CollectionLikeType listType = typeFactory.constructCollectionLikeType(Set.class, this.valueType);
            MapLikeType mapType = typeFactory.constructMapLikeType(Map.class, this.keyType, (JavaType)listType);
            HashMap root = (HashMap)ctx.readValue(parser, (JavaType)mapType);
            return new SetMap((Map)root);
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            JavaType setMapType = ListMapDeserializer.getPropertyType(ctxt, property);
            return new SetMapDeserializer<K, V>(setMapType.containedType(0), setMapType.containedType(1));
        }
    }

    private static abstract class CollectionMapDeserializerBase<K, V, C extends Collection<V>>
    extends JsonDeserializer<CollectionMap<K, V, C>> {
        protected JavaType keyType;
        protected JavaType valueType;

        public abstract CollectionMap<K, V, C> deserialize(JsonParser var1, DeserializationContext var2) throws IOException;

        private CollectionMapDeserializerBase(JavaType keyType, JavaType valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        protected static JavaType getPropertyType(DeserializationContext ctxt, BeanProperty property) {
            if (property == null) {
                return ctxt.getContextualType();
            }
            return property.getType();
        }
    }
}

