/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.LoggerRt;
import org.jetbrains.kotlin.com.intellij.util.io.DirectByteBufferPool;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassPath;
import org.jetbrains.kotlin.com.intellij.util.lang.ClasspathCache;
import org.jetbrains.kotlin.com.intellij.util.lang.Loader;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;

final class FileLoader
extends Loader {
    private static final EnumSet<StandardOpenOption> READ_OPTIONS = EnumSet.of(StandardOpenOption.READ);
    private static final EnumSet<StandardOpenOption> WRITE_OPTIONS = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    private static final AtomicInteger totalLoaders = new AtomicInteger();
    private static final AtomicLong totalScanning = new AtomicLong();
    private static final AtomicLong totalSaving = new AtomicLong();
    private static final AtomicLong totalReading = new AtomicLong();
    private static final Boolean doFsActivityLogging = false;
    private final int rootDirAbsolutePathLength;
    private final boolean isClassPathIndexEnabled;
    private static final BlockingDeque<Map.Entry<ClasspathCache.LoaderData, Path>> loaderDataToSave = new LinkedBlockingDeque<Map.Entry<ClasspathCache.LoaderData, Path>>();
    private static final AtomicBoolean isSaveThreadStarted = new AtomicBoolean();

    FileLoader(@NotNull Path path, boolean isClassPathIndexEnabled) {
        if (path == null) {
            FileLoader.$$$reportNull$$$0(0);
        }
        super(path);
        this.rootDirAbsolutePathLength = path.toString().length();
        this.isClassPathIndexEnabled = isClassPathIndexEnabled;
    }

    @Override
    @Nullable
    public Map<Loader.Attribute, String> getAttributes() throws IOException {
        return null;
    }

    private void buildPackageCache(@NotNull Path startDir, @NotNull ClasspathCache.LoaderDataBuilder context) {
        Path dir;
        if (startDir == null) {
            FileLoader.$$$reportNull$$$0(4);
        }
        if (context == null) {
            FileLoader.$$$reportNull$$$0(5);
        }
        ArrayDeque<Path> dirCandidates = new ArrayDeque<Path>();
        dirCandidates.add(startDir);
        while ((dir = (Path)dirCandidates.pollFirst()) != null) {
            try {
                DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir);
                try {
                    boolean containsClasses = false;
                    boolean containsResources = false;
                    for (Path file2 : dirStream) {
                        String path = startDir.relativize(file2).toString().replace(File.separatorChar, '/');
                        if (path.endsWith(".class")) {
                            context.andClassName(path);
                            containsClasses = true;
                            continue;
                        }
                        context.addResourceName(path, path.length());
                        containsResources = true;
                        if (path.endsWith(".svg") || path.endsWith(".png") || path.endsWith(".xml")) continue;
                        dirCandidates.addLast(file2);
                    }
                    if (!containsClasses && !containsResources) continue;
                    String relativeResourcePath = this.getRelativeResourcePath(dir.toString());
                    if (containsClasses) {
                        context.addClassPackage(relativeResourcePath);
                    }
                    if (!containsResources) continue;
                    context.addResourcePackage(relativeResourcePath);
                }
                finally {
                    if (dirStream == null) continue;
                    dirStream.close();
                }
            }
            catch (NoSuchFileException | NotDirectoryException dirStream) {
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @NotNull
    private String getRelativeResourcePath(@NotNull String absFilePath) {
        if (absFilePath == null) {
            FileLoader.$$$reportNull$$$0(6);
        }
        String relativePath = absFilePath.substring(this.rootDirAbsolutePathLength);
        String string2 = relativePath = (relativePath = relativePath.replace(File.separatorChar, '/')).startsWith("/") ? relativePath.substring(1) : relativePath;
        if (string2 == null) {
            FileLoader.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @Nullable
    Resource getResource(@NotNull String name) {
        Path file2;
        if (name == null) {
            FileLoader.$$$reportNull$$$0(8);
        }
        return Files.exists(file2 = this.path.resolve(name), new LinkOption[0]) ? new FileResource(file2) : null;
    }

    @Override
    @Nullable
    Class<?> findClass(@NotNull String fileName, String className, ClassPath.ClassDataConsumer classConsumer) throws IOException {
        byte[] data2;
        if (fileName == null) {
            FileLoader.$$$reportNull$$$0(9);
        }
        Path file2 = this.path.resolve(fileName);
        try {
            data2 = Files.readAllBytes(file2);
        }
        catch (NoSuchFileException e) {
            return null;
        }
        return classConsumer.consumeClassData(className, data2, this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClasspathCache.LoaderData readFromIndex(Path index2) {
        long started = System.nanoTime();
        boolean isOk = false;
        int version = -1;
        try (SeekableByteChannel channel = Files.newByteChannel(index2, READ_OPTIONS, new FileAttribute[0]);){
            ByteBuffer buffer = DirectByteBufferPool.DEFAULT_POOL.allocate((int)channel.size());
            try {
                do {
                    channel.read(buffer);
                } while (buffer.hasRemaining());
                buffer.flip();
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                version = buffer.getShort();
                if (version == 23) {
                    int[] classPackageHashes = new int[buffer.getInt()];
                    int[] resourcePackageHashes = new int[buffer.getInt()];
                    IntBuffer intBuffer = buffer.asIntBuffer();
                    intBuffer.get(classPackageHashes);
                    intBuffer.get(resourcePackageHashes);
                    buffer.position(buffer.position() + intBuffer.position() * 4);
                    ClasspathCache.LoaderData loaderData = new ClasspathCache.LoaderData(resourcePackageHashes, classPackageHashes, new ClasspathCache.NameFilter(buffer));
                    isOk = true;
                    ClasspathCache.LoaderData loaderData2 = loaderData;
                    return loaderData2;
                }
            }
            finally {
                DirectByteBufferPool.DEFAULT_POOL.release(buffer);
            }
        }
        catch (NoSuchFileException ignore) {
            isOk = true;
        }
        catch (Exception e) {
            LoggerRt.getInstance(FileLoader.class).warn("Cannot read classpath index (version=" + version + ", module=" + index2.getParent().getFileName() + ")", e);
        }
        finally {
            if (!isOk) {
                try {
                    Files.deleteIfExists(index2);
                }
                catch (IOException ignore) {}
            }
            totalReading.addAndGet(System.nanoTime() - started);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveToIndex(@NotNull ClasspathCache.LoaderData data2, @NotNull Path indexFile) throws IOException {
        if (data2 == null) {
            FileLoader.$$$reportNull$$$0(10);
        }
        if (indexFile == null) {
            FileLoader.$$$reportNull$$$0(11);
        }
        long started = System.nanoTime();
        boolean isOk = false;
        Channel channel = null;
        try {
            ByteBuffer buffer = DirectByteBufferPool.DEFAULT_POOL.allocate(2 + data2.sizeInBytes());
            try {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putShort((short)23);
                data2.save(buffer);
                assert (buffer.remaining() == 0);
                buffer.flip();
                channel = Files.newByteChannel(indexFile, WRITE_OPTIONS, new FileAttribute[0]);
                do {
                    channel.write(buffer);
                } while (buffer.hasRemaining());
                isOk = true;
            }
            finally {
                DirectByteBufferPool.DEFAULT_POOL.release(buffer);
            }
        }
        finally {
            block21: {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (Exception e) {
                        if (!isOk) break block21;
                        LoggerRt.getInstance(FileLoader.class).warn(e);
                    }
                }
            }
            if (!isOk) {
                try {
                    Files.deleteIfExists(indexFile);
                }
                catch (IOException iOException) {}
            }
            totalSaving.addAndGet(System.nanoTime() - started);
        }
    }

    private Path getIndexFileFile() {
        return this.path.resolve("classpath.index");
    }

    @Override
    @NotNull
    public ClasspathCache.IndexRegistrar buildData() {
        long currentScanningTime;
        Path indexFile;
        ClasspathCache.LoaderData loaderData = null;
        Path path = indexFile = this.isClassPathIndexEnabled ? this.getIndexFileFile() : null;
        if (indexFile != null) {
            loaderData = FileLoader.readFromIndex(indexFile);
        }
        int nsMsFactor = 1000000;
        int currentLoaders = totalLoaders.incrementAndGet();
        if (loaderData == null) {
            long started = System.nanoTime();
            ClasspathCache.LoaderDataBuilder loaderDataBuilder = new ClasspathCache.LoaderDataBuilder(true);
            this.buildPackageCache(this.path, loaderDataBuilder);
            loaderData = loaderDataBuilder.build();
            long doneNanos = System.nanoTime() - started;
            currentScanningTime = totalScanning.addAndGet(doneNanos);
            if (doFsActivityLogging.booleanValue()) {
                System.out.println("Scanned: " + this.path + " for " + doneNanos / (long)nsMsFactor + "ms");
            }
            if (indexFile != null) {
                loaderDataToSave.addLast(new AbstractMap.SimpleImmutableEntry<ClasspathCache.LoaderData, Path>(loaderData, indexFile));
                FileLoader.startCacheSavingIfNeeded();
            }
        } else {
            currentScanningTime = totalScanning.get();
        }
        if (doFsActivityLogging.booleanValue()) {
            System.out.println("Scanning: " + currentScanningTime / (long)nsMsFactor + "ms, loading: " + totalReading.get() / (long)nsMsFactor + "ms for " + currentLoaders + " loaders");
        }
        ClasspathCache.LoaderData loaderData2 = loaderData;
        if (loaderData2 == null) {
            FileLoader.$$$reportNull$$$0(12);
        }
        return loaderData2;
    }

    private static void startCacheSavingIfNeeded() {
        if (!isSaveThreadStarted.compareAndSet(false, true)) {
            return;
        }
        Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread2 = new Thread(r, "Save classpath indexes for file loader");
            thread2.setDaemon(true);
            thread2.setPriority(1);
            return thread2;
        }).schedule(() -> {
            block6: while (true) {
                try {
                    while (true) {
                        Map.Entry<ClasspathCache.LoaderData, Path> entry = loaderDataToSave.takeFirst();
                        Path finalFile = entry.getValue();
                        Path tempFile = finalFile.getParent().resolve("classpath.index.tmp");
                        try {
                            FileLoader.saveToIndex(entry.getKey(), tempFile);
                            try {
                                Files.move(tempFile, finalFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                            }
                            catch (AtomicMoveNotSupportedException e) {
                                Files.move(tempFile, finalFile, StandardCopyOption.REPLACE_EXISTING);
                            }
                            continue block6;
                        }
                        catch (Exception e) {
                            LoggerRt.getInstance(FileLoader.class).warn("Cannot save classpath index for module " + finalFile.getParent().getFileName(), e);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ignored) {
                    return;
                }
            }
        }, 10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "FileLoader(path=" + this.path + ')';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absFilePath";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/lang/FileLoader";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/FileLoader";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeResourcePath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildPackageCache";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeResourcePath";
                break;
            }
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveToIndex";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FileResource
    implements Resource {
        private URL url;
        private final Path file;

        FileResource(@NotNull Path file2) {
            if (file2 == null) {
                FileResource.$$$reportNull$$$0(0);
            }
            this.file = file2;
        }

        @Override
        @NotNull
        public URL getURL() {
            URL result2 = this.url;
            if (result2 == null) {
                try {
                    result2 = this.file.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                this.url = result2;
            }
            URL uRL = result2;
            if (uRL == null) {
                FileResource.$$$reportNull$$$0(1);
            }
            return uRL;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0]), 32000);
        }

        public String toString() {
            return this.file.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/lang/FileLoader$FileResource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/FileLoader$FileResource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

