/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AbstractFilteringTrace;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceSession;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinResolutionCallbacksImpl;
import org.jetbrains.kotlin.resolve.calls.tower.LambdaContextInfo;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.error.ErrorType;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class ExpressionTypingServices {
    private final ExpressionTypingFacade expressionTypingFacade;
    private final ExpressionTypingComponents expressionTypingComponents;
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final StatementFilter statementFilter;

    public ExpressionTypingServices(@NotNull ExpressionTypingComponents components2, @NotNull AnnotationChecker annotationChecker, @NotNull StatementFilter statementFilter, @NotNull ExpressionTypingVisitorDispatcher.ForDeclarations facade) {
        if (components2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(0);
        }
        if (annotationChecker == null) {
            ExpressionTypingServices.$$$reportNull$$$0(1);
        }
        if (statementFilter == null) {
            ExpressionTypingServices.$$$reportNull$$$0(2);
        }
        if (facade == null) {
            ExpressionTypingServices.$$$reportNull$$$0(3);
        }
        this.expressionTypingComponents = components2;
        this.annotationChecker = annotationChecker;
        this.statementFilter = statementFilter;
        this.expressionTypingFacade = facade;
    }

    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        LanguageVersionSettings languageVersionSettings2 = this.expressionTypingComponents.languageVersionSettings;
        if (languageVersionSettings2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(4);
        }
        return languageVersionSettings2;
    }

    @NotNull
    public StatementFilter getStatementFilter() {
        StatementFilter statementFilter = this.statementFilter;
        if (statementFilter == null) {
            ExpressionTypingServices.$$$reportNull$$$0(5);
        }
        return statementFilter;
    }

    @NotNull
    public KotlinType safeGetType(@NotNull LexicalScope scope2, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace) {
        KotlinType type2;
        if (scope2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(6);
        }
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(7);
        }
        if (expectedType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(8);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(9);
        }
        if (inferenceSession == null) {
            ExpressionTypingServices.$$$reportNull$$$0(10);
        }
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(11);
        }
        KotlinType kotlinType = (type2 = this.getType(scope2, expression2, expectedType, dataFlowInfo, inferenceSession, trace)) != null ? type2 : ErrorUtils.createErrorType(ErrorTypeKind.NO_RECORDED_TYPE, expression2.getText());
        if (kotlinType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(12);
        }
        return kotlinType;
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull LexicalScope scope2, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace, boolean isStatement) {
        if (scope2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(13);
        }
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(14);
        }
        if (expectedType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(15);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(16);
        }
        if (inferenceSession == null) {
            ExpressionTypingServices.$$$reportNull$$$0(17);
        }
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(18);
        }
        KotlinTypeInfo kotlinTypeInfo = this.getTypeInfo(scope2, expression2, expectedType, dataFlowInfo, inferenceSession, trace, isStatement, expression2, ContextDependency.INDEPENDENT);
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(19);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull LexicalScope scope2, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace, boolean isStatement, @NotNull KtExpression contextExpression, @NotNull ContextDependency contextDependency) {
        if (scope2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(20);
        }
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(21);
        }
        if (expectedType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(22);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(23);
        }
        if (inferenceSession == null) {
            ExpressionTypingServices.$$$reportNull$$$0(24);
        }
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(25);
        }
        if (contextExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(26);
        }
        if (contextDependency == null) {
            ExpressionTypingServices.$$$reportNull$$$0(27);
        }
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, scope2, dataFlowInfo, expectedType, contextDependency, this.statementFilter, this.getLanguageVersionSettings(), this.expressionTypingComponents.dataFlowValueFactory, inferenceSession);
        if (contextExpression != expression2) {
            context = (ExpressionTypingContext)context.replaceExpressionContextProvider(arg -> arg == expression2 ? contextExpression : null);
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingFacade.getTypeInfo(expression2, context, isStatement);
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(28);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull KtExpression expression2, @NotNull ResolutionContext resolutionContext) {
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(29);
        }
        if (resolutionContext == null) {
            ExpressionTypingServices.$$$reportNull$$$0(30);
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingFacade.getTypeInfo(expression2, ExpressionTypingContext.newContext(resolutionContext));
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(31);
        }
        return kotlinTypeInfo;
    }

    @Nullable
    public KotlinType getType(@NotNull LexicalScope scope2, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(32);
        }
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(33);
        }
        if (expectedType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(34);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(35);
        }
        if (inferenceSession == null) {
            ExpressionTypingServices.$$$reportNull$$$0(36);
        }
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(37);
        }
        return this.getTypeInfo(scope2, expression2, expectedType, dataFlowInfo, inferenceSession, trace, false).getType();
    }

    public void checkFunctionReturnType(@NotNull LexicalScope functionInnerScope, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull DataFlowInfo dataFlowInfo, @Nullable KotlinType expectedReturnType, BindingTrace trace, @Nullable ExpressionTypingContext localContext) {
        if (functionInnerScope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(38);
        }
        if (function2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(39);
        }
        if (functionDescriptor == null) {
            ExpressionTypingServices.$$$reportNull$$$0(40);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(41);
        }
        if (expectedReturnType == null) {
            expectedReturnType = functionDescriptor.getReturnType();
            if (!function2.hasBlockBody() && !function2.hasDeclaredReturnType()) {
                expectedReturnType = TypeUtils.NO_EXPECTED_TYPE;
            }
        }
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, functionInnerScope, dataFlowInfo, expectedReturnType != null ? expectedReturnType : TypeUtils.NO_EXPECTED_TYPE, this.getLanguageVersionSettings(), this.expressionTypingComponents.dataFlowValueFactory, localContext != null ? localContext.inferenceSession : InferenceSession.Companion.getDefault());
        this.checkFunctionReturnType(function2, context);
    }

    void checkFunctionReturnType(KtDeclarationWithBody function2, ExpressionTypingContext context) {
        KtExpression bodyExpression = function2.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        boolean blockBody = function2.hasBlockBody();
        ExpressionTypingContext newContext = blockBody ? (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE) : context;
        this.expressionTypingFacade.getTypeInfo(bodyExpression, newContext, blockBody);
    }

    @NotNull
    public KotlinTypeInfo getBlockReturnedType(KtBlockExpression expression2, ExpressionTypingContext context, boolean isStatement) {
        KotlinTypeInfo kotlinTypeInfo = this.getBlockReturnedType(expression2, isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION, context);
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(42);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo getBlockReturnedType(@NotNull KtBlockExpression expression2, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context) {
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(43);
        }
        if (coercionStrategyForLastExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(44);
        }
        if (context == null) {
            ExpressionTypingServices.$$$reportNull$$$0(45);
        }
        List<KtExpression> block = StatementFilterKt.filterStatements(this.statementFilter, expression2);
        DeclarationDescriptor containingDescriptor = context.scope.getOwnerDescriptor();
        TraceBasedLocalRedeclarationChecker redeclarationChecker = new TraceBasedLocalRedeclarationChecker(context.trace, this.expressionTypingComponents.overloadChecker);
        LexicalWritableScope scope2 = new LexicalWritableScope(context.scope, containingDescriptor, false, redeclarationChecker, LexicalScopeKind.CODE_BLOCK);
        KotlinTypeInfo r = block.isEmpty() ? this.expressionTypingComponents.dataFlowAnalyzer.createCheckedTypeInfo(this.expressionTypingComponents.builtIns.getUnitType(), context, expression2) : this.getBlockReturnedTypeWithWritableScope(scope2, block, coercionStrategyForLastExpression, (ExpressionTypingContext)context.replaceStatementFilter(this.statementFilter));
        scope2.freeze();
        if (containingDescriptor instanceof ScriptDescriptor) {
            context.trace.record(BindingContext.SCRIPT_SCOPE, (ScriptDescriptor)containingDescriptor, scope2);
        }
        KotlinTypeInfo kotlinTypeInfo = r;
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(46);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinType getBodyExpressionType(@NotNull BindingTrace trace, @NotNull LexicalScope outerScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @Nullable InferenceSession inferenceSession) {
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(47);
        }
        if (outerScope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(48);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(49);
        }
        if (function2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(50);
        }
        if (functionDescriptor == null) {
            ExpressionTypingServices.$$$reportNull$$$0(51);
        }
        KtExpression bodyExpression = function2.getBodyExpression();
        assert (bodyExpression != null);
        LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(outerScope, functionDescriptor, trace, this.expressionTypingComponents.overloadChecker);
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, functionInnerScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.getLanguageVersionSettings(), this.expressionTypingComponents.dataFlowValueFactory, inferenceSession);
        KotlinResolutionCallbacksImpl.LambdaInfo lambdaInfo = ExpressionTypingServices.getNewInferenceLambdaInfo(context, function2);
        context = ExpressionTypingServices.updateContextFromNILambdaInfo(lambdaInfo, context);
        KotlinTypeInfo typeInfo = this.expressionTypingFacade.getTypeInfo(bodyExpression, context, function2.hasBlockBody());
        ExpressionTypingServices.updateLambdaContextInfoForAnonymousFunction(lambdaInfo, typeInfo, context);
        KotlinType type2 = typeInfo.getType();
        if (type2 != null) {
            KotlinType kotlinType = type2;
            if (kotlinType == null) {
                ExpressionTypingServices.$$$reportNull$$$0(52);
            }
            return kotlinType;
        }
        ErrorType errorType = ErrorUtils.createErrorType(ErrorTypeKind.RETURN_TYPE_FOR_FUNCTION, new String[0]);
        if (errorType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(53);
        }
        return errorType;
    }

    private static void updateLambdaContextInfoForAnonymousFunction(@Nullable KotlinResolutionCallbacksImpl.LambdaInfo lambdaInfo, @NotNull KotlinTypeInfo bodyExpressionTypeInfo, @NotNull ExpressionTypingContext context) {
        if (bodyExpressionTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(54);
        }
        if (context == null) {
            ExpressionTypingServices.$$$reportNull$$$0(55);
        }
        if (lambdaInfo == null) {
            return;
        }
        LambdaContextInfo contextInfo = lambdaInfo.getLastExpressionInfo();
        contextInfo.setTypeInfo(bodyExpressionTypeInfo);
        contextInfo.setDataFlowInfoAfter(null);
        contextInfo.setLexicalScope(context.scope);
        contextInfo.setTrace(context.trace);
    }

    private static ExpressionTypingContext updateContextFromNILambdaInfo(@Nullable KotlinResolutionCallbacksImpl.LambdaInfo lambdaInfo, @NotNull ExpressionTypingContext context) {
        if (context == null) {
            ExpressionTypingServices.$$$reportNull$$$0(56);
        }
        if (lambdaInfo != null) {
            context = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceContextDependency(lambdaInfo.getContextDependency())).replaceExpectedType(lambdaInfo.getExpectedType());
        }
        return context;
    }

    @Nullable
    public static KotlinResolutionCallbacksImpl.LambdaInfo getNewInferenceLambdaInfo(@NotNull ExpressionTypingContext context, @NotNull KtElement function2) {
        if (context == null) {
            ExpressionTypingServices.$$$reportNull$$$0(57);
        }
        if (function2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(58);
        }
        if (function2 instanceof KtFunction) {
            return context.trace.get(BindingContext.NEW_INFERENCE_LAMBDA_INFO, (KtFunction)function2);
        }
        return null;
    }

    KotlinTypeInfo getBlockReturnedTypeWithWritableScope(@NotNull LexicalWritableScope scope2, @NotNull List<? extends KtElement> block, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context) {
        if (scope2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(59);
        }
        if (block == null) {
            ExpressionTypingServices.$$$reportNull$$$0(60);
        }
        if (coercionStrategyForLastExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(61);
        }
        if (context == null) {
            ExpressionTypingServices.$$$reportNull$$$0(62);
        }
        if (block.isEmpty()) {
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)this.expressionTypingComponents.builtIns.getUnitType(), context);
        }
        ExpressionTypingVisitorDispatcher.ForBlock blockLevelVisitor = new ExpressionTypingVisitorDispatcher.ForBlock(this.expressionTypingComponents, this.annotationChecker, scope2);
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(scope2)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KotlinTypeInfo result2 = TypeInfoFactoryKt.noTypeInfo(context);
        DataFlowInfo beforeJumpInfo = newContext.dataFlowInfo;
        boolean jumpOutPossible = false;
        boolean isFirstStatement = true;
        Iterator<? extends KtElement> iterator2 = block.iterator();
        while (iterator2.hasNext()) {
            ProgressManager.checkCanceled();
            EffectsFilteringTrace traceForSingleStatement = new EffectsFilteringTrace(context.trace);
            newContext = (ExpressionTypingContext)newContext.replaceBindingTrace(traceForSingleStatement);
            KtElement statement2 = iterator2.next();
            if (!(statement2 instanceof KtExpression)) continue;
            KtExpression statementExpression = (KtExpression)statement2;
            if (!iterator2.hasNext()) {
                result2 = this.getTypeOfLastExpressionInBlock(statementExpression, (ExpressionTypingContext)newContext.replaceExpectedType(context.expectedType), coercionStrategyForLastExpression, blockLevelVisitor);
                if (result2.getType() != null && statementExpression.getParent() instanceof KtBlockExpression) {
                    DataFlowValue lastExpressionValue = this.expressionTypingComponents.dataFlowValueFactory.createDataFlowValue(statementExpression, result2.getType(), context);
                    DataFlowValue blockExpressionValue = this.expressionTypingComponents.dataFlowValueFactory.createDataFlowValue((KtBlockExpression)statementExpression.getParent(), result2.getType(), context);
                    result2 = result2.replaceDataFlowInfo(result2.getDataFlowInfo().assign(blockExpressionValue, lastExpressionValue, this.expressionTypingComponents.languageVersionSettings));
                }
            } else {
                result2 = blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)newContext.replaceContextDependency(ContextDependency.INDEPENDENT), true);
            }
            DataFlowInfo newDataFlowInfo = result2.getDataFlowInfo();
            if (!jumpOutPossible) {
                beforeJumpInfo = result2.getJumpFlowInfo();
                jumpOutPossible = result2.getJumpOutPossible();
            }
            if (newDataFlowInfo != newContext.dataFlowInfo) {
                newContext = (ExpressionTypingContext)newContext.replaceDataFlowInfo(newDataFlowInfo);
            }
            blockLevelVisitor = new ExpressionTypingVisitorDispatcher.ForBlock(this.expressionTypingComponents, this.annotationChecker, scope2);
            DeclarationDescriptor ownerDescriptor = scope2.getOwnerDescriptor();
            if (!isFirstStatement || !(ownerDescriptor instanceof FunctionDescriptor)) continue;
            this.expressionTypingComponents.contractParsingServices.checkContractAndRecordIfPresent(statementExpression, context.trace, (FunctionDescriptor)ownerDescriptor);
            isFirstStatement = false;
        }
        return result2.replaceJumpOutPossible(jumpOutPossible).replaceJumpFlowInfo(beforeJumpInfo);
    }

    private KotlinTypeInfo getTypeOfLastExpressionInBlock(@NotNull KtExpression statementExpression, @NotNull ExpressionTypingContext context, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingInternals blockLevelVisitor) {
        KotlinTypeInfo typeInfo;
        boolean isUnitExpectedType;
        if (statementExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(63);
        }
        if (context == null) {
            ExpressionTypingServices.$$$reportNull$$$0(64);
        }
        if (coercionStrategyForLastExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(65);
        }
        if (blockLevelVisitor == null) {
            ExpressionTypingServices.$$$reportNull$$$0(66);
        }
        boolean bl = isUnitExpectedType = context.expectedType != TypeUtils.NO_EXPECTED_TYPE && (context.expectedType == TypeUtils.UNIT_EXPECTED_TYPE || coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT && KotlinBuiltIns.isUnit(context.expectedType));
        if (ExpressionTypingServices.isCallableReferenceShouldBeAttemptedToBeProcessedByNI(statementExpression, context, isUnitExpectedType) && (typeInfo = ExpressionTypingServices.createDontCareTypeInfoForNILambda(statementExpression, context)) != null) {
            return typeInfo;
        }
        if (context.expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            KotlinType expectedType = isUnitExpectedType ? TypeUtils.UNIT_EXPECTED_TYPE : context.expectedType;
            return blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)context.replaceExpectedType(expectedType), true);
        }
        if (KtPsiUtil.deparenthesize(statementExpression) instanceof KtLambdaExpression && context.contextDependency == ContextDependency.DEPENDENT && (typeInfo = ExpressionTypingServices.createDontCareTypeInfoForNILambda(statementExpression, context)) != null) {
            return typeInfo;
        }
        KotlinTypeInfo result2 = blockLevelVisitor.getTypeInfo(statementExpression, context, true);
        if (coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT) {
            KtBinaryExpression binaryExpression;
            IElementType operationType;
            boolean mightBeUnit = false;
            if (statementExpression instanceof KtDeclaration && (!(statementExpression instanceof KtNamedFunction) || statementExpression.getName() != null)) {
                mightBeUnit = true;
            }
            if (statementExpression instanceof KtBinaryExpression && ((operationType = (binaryExpression = (KtBinaryExpression)statementExpression).getOperationToken()) == KtTokens.EQ || OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType))) {
                mightBeUnit = true;
            }
            if (mightBeUnit) {
                assert (result2.getType() == null || KotlinBuiltIns.isUnit(result2.getType()));
                result2 = result2.replaceType(this.expressionTypingComponents.builtIns.getUnitType());
            }
        }
        return result2;
    }

    private static boolean isCallableReferenceShouldBeAttemptedToBeProcessedByNI(@NotNull KtExpression statementExpression, @NotNull ExpressionTypingContext context, boolean isUnitExpectedType) {
        if (statementExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(67);
        }
        if (context == null) {
            ExpressionTypingServices.$$$reportNull$$$0(68);
        }
        if (!(statementExpression instanceof KtCallableReferenceExpression)) {
            return false;
        }
        if (context.expectedType == TypeUtils.NO_EXPECTED_TYPE) {
            return true;
        }
        return !isUnitExpectedType && statementExpression.getParent().getParent() instanceof KtFunctionLiteral;
    }

    @Nullable
    private static KotlinTypeInfo createDontCareTypeInfoForNILambda(@NotNull KtExpression statementExpression, @NotNull ExpressionTypingContext context) {
        KotlinResolutionCallbacksImpl.LambdaInfo info;
        if (statementExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(69);
        }
        if (context == null) {
            ExpressionTypingServices.$$$reportNull$$$0(70);
        }
        if (!context.languageVersionSettings.supportsFeature(LanguageFeature.NewInference) || context.inferenceSession instanceof BuilderInferenceSession) {
            return null;
        }
        KtFunctionLiteral functionLiteral = PsiUtilsKt.getNonStrictParentOfType(statementExpression, KtFunctionLiteral.class);
        if (functionLiteral != null && (info = context.trace.getBindingContext().get(BindingContext.NEW_INFERENCE_LAMBDA_INFO, functionLiteral)) != null) {
            info.getLastExpressionInfo().setLexicalScope(context.scope);
            info.getLastExpressionInfo().setTrace(context.trace);
            return new KotlinTypeInfo(TypeUtils.DONT_CARE, context.dataFlowInfo);
        }
        return null;
    }

    public LocalRedeclarationChecker createLocalRedeclarationChecker(BindingTrace trace) {
        return new TraceBasedLocalRedeclarationChecker(trace, this.expressionTypingComponents.overloadChecker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 19: 
            case 28: 
            case 31: 
            case 42: 
            case 46: 
            case 52: 
            case 53: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 19: 
            case 28: 
            case 31: 
            case 42: 
            case 46: 
            case 52: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationChecker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 19: 
            case 28: 
            case 31: 
            case 42: 
            case 46: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices";
                break;
            }
            case 6: 
            case 13: 
            case 20: 
            case 32: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 14: 
            case 21: 
            case 29: 
            case 33: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: 
            case 15: 
            case 22: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 9: 
            case 16: 
            case 23: 
            case 35: 
            case 41: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfo";
                break;
            }
            case 10: 
            case 17: 
            case 24: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferenceSession";
                break;
            }
            case 11: 
            case 18: 
            case 25: 
            case 37: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextExpression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDependency";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolutionContext";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionInnerScope";
                break;
            }
            case 39: 
            case 50: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 40: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 44: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coercionStrategyForLastExpression";
                break;
            }
            case 45: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerScope";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyExpressionTypeInfo";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 63: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementExpression";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockLevelVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageVersionSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementFilter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "safeGetType";
                break;
            }
            case 19: 
            case 28: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfo";
                break;
            }
            case 42: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockReturnedType";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getBodyExpressionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 19: 
            case 28: 
            case 31: 
            case 42: 
            case 46: 
            case 52: 
            case 53: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "safeGetType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInfo";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionReturnType";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getBlockReturnedType";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getBodyExpressionType";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "updateLambdaContextInfoForAnonymousFunction";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "updateContextFromNILambdaInfo";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getNewInferenceLambdaInfo";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getBlockReturnedTypeWithWritableScope";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfLastExpressionInBlock";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isCallableReferenceShouldBeAttemptedToBeProcessedByNI";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createDontCareTypeInfoForNILambda";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 19: 
            case 28: 
            case 31: 
            case 42: 
            case 46: 
            case 52: 
            case 53: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EffectsFilteringTrace
    extends AbstractFilteringTrace {
        public EffectsFilteringTrace(BindingTrace parentTrace) {
            super(parentTrace, "Effects filtering trace");
        }

        @Override
        protected <K, V> boolean shouldBeHiddenFromParent(@NotNull WritableSlice<K, V> slice, K key) {
            if (slice == null) {
                EffectsFilteringTrace.$$$reportNull$$$0(0);
            }
            return slice == BindingContext.EXPRESSION_EFFECTS;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices$EffectsFilteringTrace", "shouldBeHiddenFromParent"));
        }
    }
}

