/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public final class KeysOnlyIndex
extends IndexBase
implements IUtilityIndex {
    private static final byte[] DUMMY_VALUE = new byte[0];

    public KeysOnlyIndex(IStore store) {
        super(store);
    }

    public boolean hasKey(String key) throws StorageException {
        return this.store.getWithString(key) != null;
    }

    public void storeKey(String key) throws StorageException {
        this.store.putWithString(key, DUMMY_VALUE);
    }

    public void storeKeys(List<String> keys) throws StorageException {
        ArrayList values = new ArrayList();
        keys.forEach(key -> values.add(DUMMY_VALUE));
        this.store.putWithStrings((PairList<String, byte[]>)PairList.zip(keys, values));
    }

    public Stream<String> streamKeysStartingWith(String prefix) throws StorageException {
        return StorageUtils.listKeysStartingWith(prefix, (IStore)this.store).stream().map(StringUtils::bytesToString);
    }

    public void removeKey(String key) throws StorageException {
        this.store.removeWithString(key);
    }

    public void removeKeys(List<String> keys) throws StorageException {
        this.store.removeWithStrings(keys);
    }

    public List<String> listKeys() throws StorageException {
        return StorageUtils.listStringKeys(this.store);
    }

    public void clear() throws StorageException {
        StorageUtils.clearStore(this.store);
    }

    @Override
    public IStore getWrappedStore() {
        return this.store.getWrappedStore();
    }
}

