/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.base;

import java.util.List;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StoreBase;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class BatchHandlingStoreBase
extends StoreBase {
    private final ILockProvider lockProvider;

    protected BatchHandlingStoreBase(ILockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }

    @Override
    public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
        return CollectionUtils.mapWithException(keys, this::get);
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        for (int i = 0; i < keysValues.size(); ++i) {
            this.put((byte[])keysValues.getFirst(i), (byte[])keysValues.getSecond(i));
        }
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        for (byte[] key : keys) {
            this.remove(key);
        }
    }

    @Override
    public void scan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        this.doScan(beginKey, endKey, callback, true);
    }

    @Override
    public void scanKeys(byte @Nullable [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        if (beginKey == null) {
            this.doScan(new byte[0], endKey, callback, false);
        } else {
            this.doScan(beginKey, endKey, callback, false);
        }
    }

    protected abstract void doScan(byte @NonNull [] var1, byte @Nullable [] var2, IKeyValueCallback var3, boolean var4) throws StorageException;

    @Override
    public Lock obtainLock(String suffix) {
        return this.lockProvider.obtainLock(suffix);
    }
}

