/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.extensionmanagement.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.visualstudio.services.extensionmanagement.webapi.AcquisitionOptions;
import com.microsoft.alm.visualstudio.services.extensionmanagement.webapi.ExtensionAuthorization;
import com.microsoft.alm.visualstudio.services.extensionmanagement.webapi.ExtensionDataCollection;
import com.microsoft.alm.visualstudio.services.extensionmanagement.webapi.ExtensionDataCollectionQuery;
import com.microsoft.alm.visualstudio.services.extensionmanagement.webapi.ExtensionRequestState;
import com.microsoft.alm.visualstudio.services.extensionmanagement.webapi.ExtensionState;
import com.microsoft.alm.visualstudio.services.extensionmanagement.webapi.InstalledExtension;
import com.microsoft.alm.visualstudio.services.extensionmanagement.webapi.InstalledExtensionQuery;
import com.microsoft.alm.visualstudio.services.extensionmanagement.webapi.RequestedExtension;
import com.microsoft.alm.visualstudio.services.extensionmanagement.webapi.acquisitionrequest.ExtensionAcquisitionRequest;
import com.microsoft.alm.visualstudio.services.gallery.webapi.UserExtensionPolicy;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class ExtensionManagementHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected ExtensionManagementHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public AcquisitionOptions getAcquisitionOptions(String itemId, Boolean testCommerce, Boolean isFreeOrTrialInstall) {
        UUID locationId = UUID.fromString("288dff58-d13b-468e-9671-0fb754e9398c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("itemId", itemId);
        queryParameters.addIfNotNull("testCommerce", testCommerce);
        queryParameters.addIfNotNull("isFreeOrTrialInstall", isFreeOrTrialInstall);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, AcquisitionOptions.class);
    }

    public ExtensionAcquisitionRequest requestAcquisition(ExtensionAcquisitionRequest acquisitionRequest) {
        UUID locationId = UUID.fromString("da616457-eed3-4672-92d7-18d21f5c1658");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, acquisitionRequest, "application/json", "application/json");
        return super.sendRequest(httpRequest, ExtensionAcquisitionRequest.class);
    }

    public ExtensionAuthorization registerAuthorization(String publisherName, String extensionName, UUID registrationId) {
        UUID locationId = UUID.fromString("f21cfc80-d2d2-4248-98bb-7820c74c4606");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("registrationId", registrationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ExtensionAuthorization.class);
    }

    public ObjectNode createDocumentByName(ObjectNode doc, String publisherName, String extensionName, String scopeType, String scopeValue, String collectionName) {
        UUID locationId = UUID.fromString("bbe06c18-1c8b-4fcd-b9c6-1535aaab8749");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("scopeType", scopeType);
        routeValues.put("scopeValue", scopeValue);
        routeValues.put("collectionName", collectionName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, doc, "application/json", "application/json");
        return super.sendRequest(httpRequest, ObjectNode.class);
    }

    public void deleteDocumentByName(String publisherName, String extensionName, String scopeType, String scopeValue, String collectionName, String documentId) {
        UUID locationId = UUID.fromString("bbe06c18-1c8b-4fcd-b9c6-1535aaab8749");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("scopeType", scopeType);
        routeValues.put("scopeValue", scopeValue);
        routeValues.put("collectionName", collectionName);
        routeValues.put("documentId", documentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ObjectNode getDocumentByName(String publisherName, String extensionName, String scopeType, String scopeValue, String collectionName, String documentId) {
        UUID locationId = UUID.fromString("bbe06c18-1c8b-4fcd-b9c6-1535aaab8749");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("scopeType", scopeType);
        routeValues.put("scopeValue", scopeValue);
        routeValues.put("collectionName", collectionName);
        routeValues.put("documentId", documentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ObjectNode.class);
    }

    public ArrayList<ObjectNode> getDocumentsByName(String publisherName, String extensionName, String scopeType, String scopeValue, String collectionName) {
        UUID locationId = UUID.fromString("bbe06c18-1c8b-4fcd-b9c6-1535aaab8749");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("scopeType", scopeType);
        routeValues.put("scopeValue", scopeValue);
        routeValues.put("collectionName", collectionName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ObjectNode>>(){});
    }

    public ObjectNode setDocumentByName(ObjectNode doc, String publisherName, String extensionName, String scopeType, String scopeValue, String collectionName) {
        UUID locationId = UUID.fromString("bbe06c18-1c8b-4fcd-b9c6-1535aaab8749");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("scopeType", scopeType);
        routeValues.put("scopeValue", scopeValue);
        routeValues.put("collectionName", collectionName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, doc, "application/json", "application/json");
        return super.sendRequest(httpRequest, ObjectNode.class);
    }

    public ObjectNode updateDocumentByName(ObjectNode doc, String publisherName, String extensionName, String scopeType, String scopeValue, String collectionName) {
        UUID locationId = UUID.fromString("bbe06c18-1c8b-4fcd-b9c6-1535aaab8749");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("scopeType", scopeType);
        routeValues.put("scopeValue", scopeValue);
        routeValues.put("collectionName", collectionName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, doc, "application/json", "application/json");
        return super.sendRequest(httpRequest, ObjectNode.class);
    }

    public ArrayList<ExtensionDataCollection> queryCollectionsByName(ExtensionDataCollectionQuery collectionQuery, String publisherName, String extensionName) {
        UUID locationId = UUID.fromString("56c331f1-ce53-4318-adfd-4db5c52a7a2e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, collectionQuery, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ExtensionDataCollection>>(){});
    }

    public ArrayList<ExtensionState> getStates(Boolean includeDisabled, Boolean includeErrors, Boolean includeInstallationIssues) {
        UUID locationId = UUID.fromString("92755d3d-9a8a-42b3-8a4d-87359fe5aa93");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeDisabled", includeDisabled);
        queryParameters.addIfNotNull("includeErrors", includeErrors);
        queryParameters.addIfNotNull("includeInstallationIssues", includeInstallationIssues);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ExtensionState>>(){});
    }

    public ArrayList<InstalledExtension> queryExtensions(InstalledExtensionQuery query) {
        UUID locationId = UUID.fromString("046c980f-1345-4ce2-bf85-b46d10ff4cfd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, query, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<InstalledExtension>>(){});
    }

    public ArrayList<InstalledExtension> getInstalledExtensions(Boolean includeDisabledExtensions, Boolean includeErrors, List<String> assetTypes, Boolean includeInstallationIssues) {
        UUID locationId = UUID.fromString("275424d0-c844-4fe2-bda6-04933a1357d8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeDisabledExtensions", includeDisabledExtensions);
        queryParameters.addIfNotNull("includeErrors", includeErrors);
        queryParameters.addIfNotNull("assetTypes", assetTypes);
        queryParameters.addIfNotNull("includeInstallationIssues", includeInstallationIssues);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<InstalledExtension>>(){});
    }

    public InstalledExtension updateInstalledExtension(InstalledExtension extension) {
        UUID locationId = UUID.fromString("275424d0-c844-4fe2-bda6-04933a1357d8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, apiVersion, extension, "application/json", "application/json");
        return super.sendRequest(httpRequest, InstalledExtension.class);
    }

    public InstalledExtension getInstalledExtensionByName(String publisherName, String extensionName, List<String> assetTypes) {
        UUID locationId = UUID.fromString("fb0da285-f23e-4b56-8b53-3ef5f9f6de66");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("assetTypes", assetTypes);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, InstalledExtension.class);
    }

    public InstalledExtension installExtensionByName(String publisherName, String extensionName, String version) {
        UUID locationId = UUID.fromString("fb0da285-f23e-4b56-8b53-3ef5f9f6de66");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("version", version);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, InstalledExtension.class);
    }

    public void uninstallExtensionByName(String publisherName, String extensionName, String reason, String reasonCode) {
        UUID locationId = UUID.fromString("fb0da285-f23e-4b56-8b53-3ef5f9f6de66");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("reason", reason);
        queryParameters.addIfNotEmpty("reasonCode", reasonCode);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public UserExtensionPolicy getPolicies(String userId) {
        UUID locationId = UUID.fromString("e5cc8c09-407b-4867-8319-2ae3338cbf6f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("userId", userId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, UserExtensionPolicy.class);
    }

    public int resolveRequest(String rejectMessage, String publisherName, String extensionName, String requesterId, ExtensionRequestState state) {
        UUID locationId = UUID.fromString("aa93e1f3-511c-4364-8b9c-eb98818f2e0b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("requesterId", requesterId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("state", state);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, rejectMessage, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, Integer.TYPE);
    }

    public ArrayList<RequestedExtension> getRequests() {
        UUID locationId = UUID.fromString("216b978f-b164-424e-ada2-b77561e842b7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<RequestedExtension>>(){});
    }

    public int resolveAllRequests(String rejectMessage, String publisherName, String extensionName, ExtensionRequestState state) {
        UUID locationId = UUID.fromString("ba93e1f3-511c-4364-8b9c-eb98818f2e0b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("state", state);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, rejectMessage, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, Integer.TYPE);
    }

    public void deleteRequest(String publisherName, String extensionName) {
        UUID locationId = UUID.fromString("f5afca1e-a728-4294-aa2d-4af0173431b5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public RequestedExtension requestExtension(String publisherName, String extensionName, String requestMessage) {
        UUID locationId = UUID.fromString("f5afca1e-a728-4294-aa2d-4af0173431b5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, requestMessage, "application/json", "application/json");
        return super.sendRequest(httpRequest, RequestedExtension.class);
    }

    public String getToken() {
        UUID locationId = UUID.fromString("3a2e24ed-1d6f-4cb2-9f3b-45a96bbfaf50");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, String.class);
    }
}

