/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.favorites;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.favorites.FavoriteItem;
import com.microsoft.tfs.core.clients.favorites.IFavoritesStore;
import com.microsoft.tfs.core.clients.favorites.exceptions.DuplicateFavoritesException;
import com.microsoft.tfs.core.clients.favorites.exceptions.FavoritesException;
import com.microsoft.tfs.core.clients.framework.internal.ServiceInterfaceIdentifiers;
import com.microsoft.tfs.core.clients.webservices.IIdentityManagementService2;
import com.microsoft.tfs.core.clients.webservices.IdentityPropertyScope;
import com.microsoft.tfs.core.clients.webservices.MembershipQuery;
import com.microsoft.tfs.core.clients.webservices.ReadIdentityOptions;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.json.JSONParseException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdentityFavoritesStore
implements IFavoritesStore {
    private static final Log log = LogFactory.getLog(IdentityFavoritesStore.class);
    private final Object lock = new Object();
    private TFSTeamProjectCollection tpc;
    private String filterNamespace;
    private GUID identityGUID = GUID.EMPTY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(TFSTeamProjectCollection tpc, String filterNamespace, GUID identity) {
        Check.notNull(tpc, "tpc");
        Check.notNullOrEmpty(filterNamespace, "filterNamespace");
        Check.notNull(identity, "identity");
        String location = tpc.getServerDataProvider().locationForCurrentConnection("IdentityManagementService2", ServiceInterfaceIdentifiers.COLLECTION_IDENTITY_MANAGEMENT_2);
        if (location != null && location.length() > 0) {
            Object object = this.lock;
            synchronized (object) {
                this.tpc = tpc;
                this.filterNamespace = filterNamespace;
                this.identityGUID = identity;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.lock;
        synchronized (object) {
            return this.tpc != null && !GUID.EMPTY.equals(this.identityGUID) && this.filterNamespace != null && this.filterNamespace.length() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FavoriteItem[] getFavorites() {
        Object object = this.lock;
        synchronized (object) {
            Check.isTrue(this.isConnected(), "isConnected()");
            return IdentityFavoritesStore.getFavorites(this.getCurrentIdentity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFavorites(FavoriteItem[] items) {
        Object object = this.lock;
        synchronized (object) {
            Check.isTrue(this.isConnected(), "isConnected()");
            TeamFoundationIdentity identity = this.getCurrentIdentity();
            IdentityFavoritesStore.updateFavorites(identity, this.filterNamespace, items);
            IdentityFavoritesStore.flushFavorites(identity, this.tpc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(GUID[] items) {
        Object object = this.lock;
        synchronized (object) {
            Check.isTrue(this.isConnected(), "isConnected()");
            TeamFoundationIdentity identity = this.getCurrentIdentity();
            IdentityFavoritesStore.remove(identity, this.filterNamespace, items);
            IdentityFavoritesStore.flushFavorites(identity, this.tpc);
        }
    }

    @Override
    public GUID getIdentity() {
        return this.identityGUID;
    }

    private TeamFoundationIdentity getCurrentIdentity() {
        if (this.isConnected()) {
            return IdentityFavoritesStore.getCurrentIdentity(this.tpc, this.identityGUID, this.filterNamespace);
        }
        return null;
    }

    private static TeamFoundationIdentity getCurrentIdentity(TFSTeamProjectCollection tpc, GUID identityGuid, String filterNamespace) {
        if (tpc != null) {
            String[] propertyNameFilters = new String[]{filterNamespace + "*"};
            IIdentityManagementService2 identitySvc = (IIdentityManagementService2)tpc.getClient(IIdentityManagementService2.class);
            TeamFoundationIdentity[] ids = identitySvc.readIdentities(new GUID[]{identityGuid}, MembershipQuery.DIRECT, ReadIdentityOptions.EXTENDED_PROPERTIES, propertyNameFilters, IdentityPropertyScope.LOCAL);
            Check.isTrue(ids.length == 1, "ids.length == 1");
            return ids[0];
        }
        return null;
    }

    private static FavoriteItem[] getFavorites(TeamFoundationIdentity identity) {
        Check.notNull(identity, "identity");
        Iterable<Map.Entry<String, Object>> result = identity.getProperties(IdentityPropertyScope.LOCAL);
        ArrayList<FavoriteItem> favorites = new ArrayList<FavoriteItem>();
        for (Map.Entry<String, Object> entry : result) {
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            try {
                favorites.add(FavoriteItem.deserialize((String)value));
            }
            catch (JSONParseException e) {
                log.error((Object)MessageFormat.format("Error deserializing favorite from JSON: {0}", value), (Throwable)e);
            }
        }
        return favorites.toArray(new FavoriteItem[favorites.size()]);
    }

    private static void updateFavorites(TeamFoundationIdentity identity, String effectiveNamespace, FavoriteItem[] items) {
        HashMap<GUID, FavoriteItem> favorites = new HashMap<GUID, FavoriteItem>();
        for (FavoriteItem item : IdentityFavoritesStore.getFavorites(identity)) {
            favorites.put(item.getID(), item);
        }
        for (FavoriteItem favItem : items) {
            if (!GUID.EMPTY.equals(favItem.getParentID()) && !favorites.containsKey(favItem.getParentID())) {
                throw new FavoritesException(Messages.getString("IdentityFavoritesStore.ParentFavoriteNotFound"));
            }
            for (FavoriteItem f : favorites.values()) {
                if (!f.getParentID().equals(favItem.getParentID()) || f.getID().equals(favItem.getID()) || String.CASE_INSENSITIVE_ORDER.compare(f.getType() + "", favItem.getType() + "") != 0 || String.CASE_INSENSITIVE_ORDER.compare(f.getName() + "", favItem.getName() + "") != 0 || String.CASE_INSENSITIVE_ORDER.compare(f.getData() + "", favItem.getData() + "") != 0) continue;
                throw new DuplicateFavoritesException(Messages.getString("IdentityFavoritesStore.FavoriteWithSameNameTypeDataExists"), favItem);
            }
            IdentityFavoritesStore.setViewProperty(identity, IdentityPropertyScope.LOCAL, effectiveNamespace, favItem.getID().getGUIDString(), favItem.serialize());
        }
    }

    private static void flushFavorites(TeamFoundationIdentity identity, TFSTeamProjectCollection tpc) {
        IIdentityManagementService2 identitySvc = (IIdentityManagementService2)tpc.getClient(IIdentityManagementService2.class);
        identitySvc.updateExtendedProperties(identity);
    }

    private static void remove(TeamFoundationIdentity identity, String effectiveNamespace, GUID[] items) {
        if (items == null || items.length == 0) {
            return;
        }
        boolean allEmpty = true;
        for (GUID item : items) {
            if (GUID.EMPTY.equals(item)) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            return;
        }
        HashMap<GUID, FavoriteItem> dict = new HashMap<GUID, FavoriteItem>();
        for (FavoriteItem item : IdentityFavoritesStore.getFavorites(identity)) {
            dict.put(item.getID(), item);
        }
        HashSet<GUID> itemsToDelete = new HashSet<GUID>(Arrays.asList(items));
        for (FavoriteItem favItem : dict.values()) {
            IdentityFavoritesStore.fixTree(favItem, dict, itemsToDelete);
        }
        for (GUID id : itemsToDelete) {
            IdentityFavoritesStore.removeViewProperty(identity, IdentityPropertyScope.LOCAL, effectiveNamespace, id.getGUIDString());
        }
    }

    private static void setViewProperty(TeamFoundationIdentity identity, IdentityPropertyScope propertyScope, String effectiveNamespace, String propertyName, Object propertyValue) {
        identity.setProperty(propertyScope, effectiveNamespace + propertyName, propertyValue);
    }

    private static void removeViewProperty(TeamFoundationIdentity identity, IdentityPropertyScope propertyScope, String effectiveNamespace, String propertyName) {
        IdentityFavoritesStore.setViewProperty(identity, propertyScope, effectiveNamespace, propertyName, null);
    }

    private static boolean fixTree(FavoriteItem item, Map<GUID, FavoriteItem> items, Set<GUID> itemsToDelete) {
        boolean result = false;
        if (itemsToDelete.contains(item.getID())) {
            return result;
        }
        if (GUID.EMPTY.equals(item.getParentID())) {
            result = true;
        } else if (items.containsKey(item.getParentID())) {
            result = IdentityFavoritesStore.fixTree(items.get(item.getParentID()), items, itemsToDelete);
        }
        if (!result) {
            itemsToDelete.add(item.getID());
        }
        return result;
    }
}

