/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes;

import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttributeImpl;
import com.microsoft.tfs.util.Check;

public final class StringPairFileAttribute
extends FileAttributeImpl {
    private String value;
    public static final char SEPARATOR = '=';

    public StringPairFileAttribute(String name, String value) {
        super(name);
        Check.notNull(value, "value");
        this.value = value;
    }

    public static boolean looksLikeStringPairFileAttribute(String serializedAttribute) {
        Check.notNull(serializedAttribute, "serializedAttribute");
        return serializedAttribute.indexOf(61) != -1;
    }

    public static StringPairFileAttribute parse(String serializedAttribute) {
        if (serializedAttribute == null || serializedAttribute.length() == 0) {
            return null;
        }
        int separatorIndex = serializedAttribute.indexOf(61);
        if (separatorIndex < 0) {
            return new StringPairFileAttribute(serializedAttribute.trim(), "");
        }
        String keyString = serializedAttribute.substring(0, separatorIndex).trim();
        if (keyString.length() == 0) {
            return null;
        }
        String valueString = serializedAttribute.substring(separatorIndex + 1);
        return new StringPairFileAttribute(keyString, valueString.trim());
    }

    @Override
    public synchronized String toString() {
        return this.getName() + '=' + (this.value != null ? this.value.toString() : "");
    }

    public String getValue() {
        return this.value;
    }

    public synchronized void setValue(String value) {
        Check.notNull(value, "value");
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringPairFileAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        StringPairFileAttribute other = (StringPairFileAttribute)obj;
        return other.getName().equals(this.getName()) && other.getValue().equals(this.getValue());
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.getName() == null ? 0 : this.getName().hashCode());
        result = result * 37 + (this.getValue() == null ? 0 : this.getValue().hashCode());
        return result;
    }
}

