/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.link;

import com.microsoft.tfs.core.clients.workitem.internal.links.WITComponent;
import com.microsoft.tfs.core.clients.workitem.link.Link;
import com.microsoft.tfs.core.clients.workitem.link.RegisteredLinkType;

public abstract class LinkImpl
extends WITComponent
implements Link {
    private final RegisteredLinkType linkType;
    private String originalComment;
    private String newComment;
    private final boolean readOnly;
    private String description;
    private boolean descriptionComputed = false;

    protected LinkImpl(RegisteredLinkType linkType, String comment, int extId, boolean newComponent, boolean readOnly) {
        super(newComponent);
        this.linkType = linkType;
        this.setExtID(extId);
        this.validateTextMaxLength(comment, "comment", 255);
        this.originalComment = comment;
        this.readOnly = readOnly;
    }

    @Override
    public int getLinkID() {
        return this.getExtID();
    }

    @Override
    public RegisteredLinkType getLinkType() {
        return this.linkType;
    }

    @Override
    public String getComment() {
        if (this.isPendingModification()) {
            return this.newComment;
        }
        return this.originalComment;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setComment(String commentInput) {
        boolean equalToOriginal;
        this.validateTextMaxLength(commentInput, "comment", 255);
        if (this.isNewlyCreated()) {
            this.originalComment = commentInput;
            return;
        }
        boolean bl = commentInput == null ? this.originalComment == null : (equalToOriginal = commentInput.equals(this.originalComment));
        if (this.isPendingModification()) {
            if (equalToOriginal) {
                this.setPendingModification(false);
                this.getAssociatedCollection().possiblyChangedDirtyState();
            }
        } else if (!equalToOriginal) {
            this.newComment = commentInput;
            this.setPendingModification(true);
            this.getAssociatedCollection().possiblyChangedDirtyState();
        }
    }

    @Override
    public String getDescription() {
        if (!this.descriptionComputed) {
            return this.getFallbackDescription();
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.descriptionComputed = true;
    }

    public boolean isDescriptionComputed() {
        return this.descriptionComputed;
    }

    @Override
    protected void onUpdate() {
        if (this.isPendingModification()) {
            this.originalComment = this.newComment;
        }
    }

    @Override
    protected boolean isEquivalentTo(WITComponent other) {
        return this.isEquivalent((Link)((Object)other));
    }

    public abstract boolean isEquivalent(Link var1);

    public abstract LinkImpl cloneLink();

    protected String getFallbackDescription() {
        return "";
    }
}

