/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util;

import com.microsoft.tfs.core.httpclient.DefaultNTCredentials;
import com.microsoft.tfs.core.httpclient.auth.NTLMScheme;
import com.microsoft.tfs.core.httpclient.auth.NegotiateScheme;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserNameUtil {
    private static final Log log = LogFactory.getLog(UserNameUtil.class);
    public static final char DOMAIN_SEPARATOR = '\\';
    private static Object currentUserLock = new Object();
    private static boolean currentUserInitialized = false;
    private static String currentUserName;
    private static String currentUserDomain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentUserName() {
        Object object = currentUserLock;
        synchronized (object) {
            UserNameUtil.ensureCurrentUserInitialized();
            return currentUserName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentUserDomain() {
        Object object = currentUserLock;
        synchronized (object) {
            UserNameUtil.ensureCurrentUserInitialized();
            return currentUserDomain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureCurrentUserInitialized() {
        Object object = currentUserLock;
        synchronized (object) {
            if (currentUserInitialized) {
                return;
            }
            String defaultCredentials = null;
            if (NegotiateScheme.supportsCredentials(DefaultNTCredentials.class)) {
                defaultCredentials = NegotiateScheme.getDefaultCredentials();
            }
            if (defaultCredentials == null && NTLMScheme.supportsCredentials(DefaultNTCredentials.class)) {
                defaultCredentials = NTLMScheme.getDefaultCredentials();
            }
            if (defaultCredentials != null) {
                int separatorIdx = defaultCredentials.indexOf("@");
                if (separatorIdx >= 0) {
                    currentUserName = defaultCredentials.substring(0, separatorIdx);
                    currentUserDomain = defaultCredentials.substring(separatorIdx + 1);
                } else {
                    currentUserName = defaultCredentials;
                }
            } else if (Platform.isCurrentPlatform(Platform.WINDOWS)) {
                NTUserInfo info = UserNameUtil.lookUpNTUserInfo();
                if (info != null) {
                    currentUserName = info.getUserName();
                    currentUserDomain = info.getDomain();
                } else {
                    currentUserDomain = PlatformMiscUtils.getInstance().getEnvironmentVariable("USERDOMAIN");
                    currentUserName = PlatformMiscUtils.getInstance().getEnvironmentVariable("USERNAME");
                }
            }
            if (currentUserName == null) {
                currentUserName = System.getProperty("user.name");
            }
            currentUserInitialized = true;
        }
    }

    public static boolean equals(String username1, String username2) {
        Check.notNull(username1, "username1");
        Check.notNull(username2, "username2");
        return username1.equalsIgnoreCase(username2);
    }

    public static int compare(String username1, String username2) {
        ParsedUserName p1 = UserNameUtil.parse(username1);
        ParsedUserName p2 = UserNameUtil.parse(username2);
        int val = p1.getName().compareToIgnoreCase(p2.getName());
        if (val != 0) {
            return val;
        }
        if (p1.getDomain() == null && p2.getDomain() == null) {
            return 0;
        }
        if (p1.getDomain() == null) {
            return -1;
        }
        if (p2.getDomain() == null) {
            return 1;
        }
        return p1.getDomain().compareToIgnoreCase(p2.getDomain());
    }

    public static Comparator<String> newUsernameComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String username1, String username2) {
                return UserNameUtil.compare(username1, username2);
            }
        };
    }

    public static boolean hasDomain(String userName) {
        String domain = UserNameUtil.getDomain(userName);
        return domain != null && domain.length() > 0;
    }

    public static String getDomain(String userName) {
        return UserNameUtil.parse(userName).getDomain();
    }

    public static String getName(String userName) {
        return UserNameUtil.parse(userName).getName();
    }

    public static void getIdentityName(String identityType, String displayName, String attribute2, String attribute22, int uniqueUserID, AtomicReference<String> outResolvableName, AtomicReference<String> outDisplayableName) {
    }

    public static boolean isComplete(String userName) {
        Check.notNullOrEmpty(userName, "userName");
        if (userName.indexOf(92) < 0) {
            return userName.equals(".");
        }
        return true;
    }

    public static String makeComplete(String userName, String relative, boolean allowAuthenticatedUserConstant) {
        Check.notNullOrEmpty(userName, "userName");
        if (UserNameUtil.hasDomain(userName)) {
            return userName;
        }
        if (allowAuthenticatedUserConstant && ".".equals(userName)) {
            return userName;
        }
        String defaultDomain = relative == null ? UserNameUtil.getCurrentUserDomain() : (relative.indexOf(92) != -1 ? UserNameUtil.getDomain(relative) : relative);
        if (defaultDomain == null) {
            return userName;
        }
        return defaultDomain + '\\' + userName;
    }

    public static String format(String username, String domain) {
        Check.notNull(username, "username");
        StringBuffer buffer = new StringBuffer();
        if (domain != null && domain.length() > 0) {
            buffer.append(domain);
            buffer.append('\\');
        }
        buffer.append(username);
        return buffer.toString();
    }

    public static String removeDomain(String userName) {
        ParsedUserName parsedUserName = UserNameUtil.parse(userName);
        return parsedUserName.getName();
    }

    public static ParsedUserName parse(String userName) {
        Check.notNull(userName, "userName");
        int ix = userName.indexOf(92);
        if (ix == -1) {
            return new ParsedUserName(null, userName);
        }
        if (ix == userName.length() - 1) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid user name: [{0}]", userName));
        }
        String domain = userName.substring(0, ix);
        String name = userName.substring(ix + 1);
        return new ParsedUserName(domain, name);
    }

    private static NTUserInfo lookUpNTUserInfo() {
        try {
            Class<?> c = Class.forName("com.sun.security.auth.module.NTSystem");
            Object instance = c.newInstance();
            String userName = (String)c.getMethod("getName", null).invoke(instance, (Object[])null);
            String domain = (String)c.getMethod("getDomain", null).invoke(instance, (Object[])null);
            String domainSID = (String)c.getMethod("getDomainSID", null).invoke(instance, (Object[])null);
            String userSID = (String)c.getMethod("getUserSID", null).invoke(instance, (Object[])null);
            String primaryGroupID = (String)c.getMethod("getPrimaryGroupID", null).invoke(instance, (Object[])null);
            String[] groupIDs = (String[])c.getMethod("getGroupIDs", null).invoke(instance, (Object[])null);
            long impersonationToken = (Long)c.getMethod("getImpersonationToken", null).invoke(instance, (Object[])null);
            return new NTUserInfo(userName, domain, domainSID, userSID, primaryGroupID, groupIDs, impersonationToken);
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to get NT user info", t);
            }
            return null;
        }
    }

    private static class NTUserInfo {
        private final String userName;
        private final String domain;

        public NTUserInfo(String userName, String domain, String domainSID, String userSID, String primaryGroupID, String[] groupIDs, long impersonationToken) {
            this.userName = userName;
            this.domain = domain;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getDomain() {
            return this.domain;
        }
    }

    public static class ParsedUserName {
        private final String domain;
        private final String name;

        public ParsedUserName(String domain, String name) {
            Check.notNull(name, "name");
            this.domain = domain;
            this.name = name;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getName() {
            return this.name;
        }
    }
}

