/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.internal.ntlm;

import com.microsoft.tfs.jni.Messages;
import com.microsoft.tfs.jni.NTLM;
import com.microsoft.tfs.jni.internal.auth.NativeAuth;
import com.microsoft.tfs.jni.internal.ntlm.NTLMException;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;

public class NativeNTLM
implements NTLM {
    public static boolean isAvailable() {
        try {
            return NativeAuth.authAvailable((short)1);
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
        catch (LinkageError e) {
            return false;
        }
    }

    @Override
    public boolean supportsCredentialsDefault() {
        return NativeAuth.authSupportsCredentialsDefault((short)1);
    }

    @Override
    public boolean supportsCredentialsSpecified() {
        return NativeAuth.authSupportsCredentialsSpecified((short)1);
    }

    @Override
    public String getCredentialsDefault() {
        return NativeAuth.authGetCredentialsDefault((short)1);
    }

    @Override
    public NTLM.NTLMState initialize() throws NTLMException {
        try {
            long id = NativeAuth.authInitialize((short)1);
            if (id == 0L) {
                throw new NTLMException(Messages.getString("NativeNTLM.CouldNotInitializeNTLMLibraries"));
            }
            return new NativeNTLMState(id);
        }
        catch (Exception e) {
            throw new NTLMException(e.getMessage());
        }
    }

    @Override
    public void setCredentialsDefault(NTLM.NTLMState state) throws NTLMException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNTLMState, "state instanceof NativeNTLMState");
        try {
            NativeAuth.authSetCredentialsDefault(((NativeNTLMState)state).id);
        }
        catch (Exception e) {
            throw new NTLMException(e.getMessage());
        }
    }

    @Override
    public void setCredentialsSpecified(NTLM.NTLMState state, String username, String domain, String password) throws NTLMException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNTLMState, "state instanceof NativeNTLMState");
        try {
            NativeAuth.authSetCredentialsSpecified(((NativeNTLMState)state).id, username, domain, password);
        }
        catch (Exception e) {
            throw new NTLMException(e.getMessage());
        }
    }

    @Override
    public void setLocalhost(NTLM.NTLMState state, String localhost) throws NTLMException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNTLMState, "state instanceof NativeNTLMState");
        try {
            NativeAuth.authSetLocalhost(((NativeNTLMState)state).id, localhost != null ? localhost : "");
        }
        catch (Exception e) {
            throw new NTLMException(e.getMessage());
        }
    }

    @Override
    public void setTarget(NTLM.NTLMState state, String target) throws NTLMException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNTLMState, "state instanceof NativeNTLMState");
        try {
            NativeAuth.authSetTarget(((NativeNTLMState)state).id, target != null ? target : "");
        }
        catch (Exception e) {
            throw new NTLMException(e.getMessage());
        }
    }

    @Override
    public byte[] getToken(NTLM.NTLMState state, byte[] inputToken) throws NTLMException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNTLMState, "state instanceof NativeNTLMState");
        try {
            return NativeAuth.authGetToken(((NativeNTLMState)state).id, inputToken);
        }
        catch (Exception e) {
            throw new NTLMException(e.getMessage());
        }
    }

    @Override
    public boolean isComplete(NTLM.NTLMState state) throws NTLMException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNTLMState, "state instanceof NativeNTLMState");
        try {
            return NativeAuth.authIsComplete(((NativeNTLMState)state).id);
        }
        catch (Exception e) {
            throw new NTLMException(e.getMessage());
        }
    }

    @Override
    public String getErrorMessage(NTLM.NTLMState state) {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNTLMState, "state instanceof NativeNTLMState");
        try {
            return NativeAuth.authGetErrorMessage(((NativeNTLMState)state).id);
        }
        catch (Exception e) {
            return MessageFormat.format(Messages.getString("NativeNTLM.CouldNotCallNativeNTLMFormat"), e.getLocalizedMessage());
        }
    }

    @Override
    public void dispose(NTLM.NTLMState state) throws NTLMException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNTLMState, "state instanceof NativeNTLMState");
        try {
            NativeAuth.authDispose(((NativeNTLMState)state).id);
        }
        catch (Exception e) {
            throw new NTLMException(e.getMessage());
        }
    }

    private static class NativeNTLMState
    extends NTLM.NTLMState {
        private long id = 0L;

        public NativeNTLMState(long id) {
            this.id = id;
        }
    }
}

