/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.client.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.bozaro.gitlfs.client.AuthHelper;
import ru.bozaro.gitlfs.client.BatchSettings;
import ru.bozaro.gitlfs.client.Client;
import ru.bozaro.gitlfs.client.exceptions.ForbiddenException;
import ru.bozaro.gitlfs.client.exceptions.UnauthorizedException;
import ru.bozaro.gitlfs.client.internal.BatchWorker;
import ru.bozaro.gitlfs.client.internal.JsonPost;
import ru.bozaro.gitlfs.client.internal.Request;
import ru.bozaro.gitlfs.client.internal.Work;
import ru.bozaro.gitlfs.common.data.BatchItem;
import ru.bozaro.gitlfs.common.data.BatchReq;
import ru.bozaro.gitlfs.common.data.BatchRes;
import ru.bozaro.gitlfs.common.data.Error;
import ru.bozaro.gitlfs.common.data.Link;
import ru.bozaro.gitlfs.common.data.Meta;
import ru.bozaro.gitlfs.common.data.Operation;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0002CDB%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0004J%\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010(J*\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020*2\u0006\u00102\u001a\u00020\u0014H\u0002J.\u00103\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u0001042\u0014\u00105\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001c2\u0006\u00106\u001a\u000207H$J4\u00108\u001a\u00020*2\u0014\u00105\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001c2\u0006\u00102\u001a\u00020\u00142\f\u00109\u001a\b\u0012\u0004\u0012\u00028\u000104H\u0002J\u0010\u0010:\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0002J\b\u0010;\u001a\u00020*H\u0002J.\u0010<\u001a\u00020*2\u0014\u00105\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001c2\u0006\u00106\u001a\u0002072\u0006\u00102\u001a\u00020\u0014H\u0002J\"\u0010=\u001a\u001c\u0012\u0004\u0012\u00020\u001b\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001c0>H\u0002J\u0018\u0010?\u001a\u0002002\u0006\u0010@\u001a\u00020A2\u0006\u0010/\u001a\u000200H\u0002J\b\u0010B\u001a\u000200H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0019\u001a\u001c\u0012\u0004\u0012\u00020\u001b\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lru/bozaro/gitlfs/client/internal/BatchWorker;", "T", "R", "", "client", "Lru/bozaro/gitlfs/client/Client;", "pool", "Ljava/util/concurrent/ExecutorService;", "settings", "Lru/bozaro/gitlfs/client/BatchSettings;", "operation", "Lru/bozaro/gitlfs/common/data/Operation;", "(Lru/bozaro/gitlfs/client/Client;Ljava/util/concurrent/ExecutorService;Lru/bozaro/gitlfs/client/BatchSettings;Lru/bozaro/gitlfs/common/data/Operation;)V", "batchInProgress", "Ljava/util/concurrent/atomic/AtomicInteger;", "batchSequence", "getClient", "()Lru/bozaro/gitlfs/client/Client;", "currentAuth", "Ljava/util/concurrent/atomic/AtomicReference;", "Lru/bozaro/gitlfs/common/data/Link;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "objectInProgress", "objectQueue", "Ljava/util/concurrent/ConcurrentMap;", "", "Lru/bozaro/gitlfs/client/internal/BatchWorker$State;", "getPool", "()Ljava/util/concurrent/ExecutorService;", "createError", "", "error", "Lru/bozaro/gitlfs/common/data/Error;", "enqueue", "Ljava/util/concurrent/CompletableFuture;", "meta", "Lru/bozaro/gitlfs/common/data/Meta;", "context", "(Lru/bozaro/gitlfs/common/data/Meta;Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;", "executeInPool", "", "name", "task", "Ljava/lang/Runnable;", "finalizer", "pooled", "", "invalidateAuth", "auth", "objectTask", "Lru/bozaro/gitlfs/client/internal/Work;", "state", "item", "Lru/bozaro/gitlfs/common/data/BatchItem;", "processObject", "worker", "stateEnqueue", "submitBatchTask", "submitTask", "takeBatch", "", "tryBatchRequest", "batchId", "", "tryBatchRequestPredicate", "State", "StateHolder", "gitlfs-client"})
public abstract class BatchWorker<T, R> {
    @NotNull
    private final Client client;
    @NotNull
    private final ExecutorService pool;
    @NotNull
    private final BatchSettings settings;
    @NotNull
    private final Operation operation;
    private final Logger log;
    @NotNull
    private final AtomicInteger batchSequence;
    @NotNull
    private final AtomicInteger batchInProgress;
    @NotNull
    private final ConcurrentMap<String, State<T, R>> objectQueue;
    @NotNull
    private final AtomicInteger objectInProgress;
    @NotNull
    private final AtomicReference<Link> currentAuth;

    public BatchWorker(@NotNull Client client, @NotNull ExecutorService pool, @NotNull BatchSettings settings, @NotNull Operation operation) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        this.client = client;
        this.pool = pool;
        this.settings = settings;
        this.operation = operation;
        this.log = LoggerFactory.getLogger(BatchWorker.class);
        this.batchSequence = new AtomicInteger(0);
        this.batchInProgress = new AtomicInteger();
        this.objectQueue = new ConcurrentHashMap();
        this.objectInProgress = new AtomicInteger(0);
        this.currentAuth = new AtomicReference<Object>(null);
    }

    @NotNull
    protected final Client getClient() {
        return this.client;
    }

    @NotNull
    protected final ExecutorService getPool() {
        return this.pool;
    }

    @NotNull
    protected final CompletableFuture<R> enqueue(@NotNull Meta meta, T context) {
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        State state = (State)this.objectQueue.get(meta.getOid());
        if (state != null && state.getFuture().isCancelled()) {
            this.objectQueue.remove(meta.getOid(), state);
            state = null;
        }
        if (state == null) {
            State newState = new State(meta, context);
            state = this.objectQueue.putIfAbsent(meta.getOid(), newState);
            if (state == null) {
                state = newState;
                this.stateEnqueue(true);
            }
        }
        return state.getFuture();
    }

    private final void stateEnqueue(boolean pooled) {
        int batchId = this.batchSequence.incrementAndGet();
        this.tryBatchRequest(batchId, pooled);
    }

    private final boolean tryBatchRequestPredicate() {
        return this.objectInProgress.get() < this.settings.getThreshold() && !this.objectQueue.isEmpty();
    }

    private final boolean tryBatchRequest(int batchId, boolean pooled) {
        if (!this.tryBatchRequestPredicate()) {
            return false;
        }
        if (this.batchInProgress.compareAndSet(0, batchId)) {
            this.executeInPool("batch request: " + this.objectQueue.size() + " in queue", () -> BatchWorker.tryBatchRequest$lambda$0(batchId, this), () -> BatchWorker.tryBatchRequest$lambda$1(this, batchId), pooled);
            return true;
        }
        return false;
    }

    private final void invalidateAuth(Link auth) {
        if (this.currentAuth.compareAndSet(auth, null)) {
            this.client.getAuthProvider().invalidateAuth(this.operation, auth);
        }
    }

    private final void submitBatchTask() {
        block8: {
            Map<String, State<T, R>> batch = this.takeBatch();
            Link auth = this.currentAuth.get();
            try {
                if (!(!batch.isEmpty())) break block8;
                if (auth == null) {
                    auth = this.client.getAuthProvider().getAuth(this.operation);
                    this.currentAuth.set(auth);
                }
                List metas2 = batch.values().stream().map(arg_0 -> BatchWorker.submitBatchTask$lambda$2(submitBatchTask.metas.1.INSTANCE, arg_0)).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(metas2, (String)"metas");
                String[] stringArray = new String[]{"objects/batch"};
                BatchRes result = (BatchRes)this.client.doRequest(auth, (Request)new JsonPost<BatchReq, BatchRes>(new BatchReq(this.operation, metas2), BatchRes.class), AuthHelper.INSTANCE.join(auth.getHref(), stringArray), Client.ConnectionClosePolicy.Close);
                for (BatchItem batchItem : result.getObjects()) {
                    State<T, R> state = batch.remove(batchItem.getOid());
                    if (state == null) continue;
                    Error error = batchItem.getError();
                    if (error != null) {
                        this.objectQueue.remove(batchItem.getOid(), state);
                        state.getFuture().completeExceptionally(this.createError(error));
                        continue;
                    }
                    this.submitTask(state, batchItem, auth);
                }
                for (State state : batch.values()) {
                    state.getFuture().completeExceptionally(new IOException("Requested object not found in server response: " + state.getMeta().getOid()));
                }
            }
            catch (UnauthorizedException e) {
                Link link = auth;
                if (link == null) break block8;
                Link link2 = link;
                boolean bl = false;
                this.invalidateAuth(link2);
            }
            catch (IOException e) {
                for (State<T, R> state : batch.values()) {
                    state.onException(e, state.getRetry());
                }
            }
        }
    }

    @NotNull
    protected final Throwable createError(@NotNull Error error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return error.getCode() == 404 ? (Throwable)new FileNotFoundException(error.getMessage()) : (Throwable)new IOException("Can't process object (code " + error.getCode() + "): " + error.getMessage());
    }

    @Nullable
    protected abstract Work<R> objectTask(@NotNull State<T, R> var1, @NotNull BatchItem var2);

    private final void submitTask(State<T, R> state, BatchItem item, Link auth) {
        StateHolder holder = new StateHolder(state);
        try {
            state.setAuth(auth);
            Work<R> worker = this.objectTask(state, item);
            if (state.getFuture().isDone()) {
                holder.close();
                return;
            }
            if (worker == null) {
                boolean bl = false;
                String string = "Uncompleted task worker is null: " + item;
                throw new IllegalStateException(string.toString());
            }
            this.executeInPool("task: " + state.getMeta().getOid(), () -> BatchWorker.submitTask$lambda$5(this, state, auth, worker), () -> BatchWorker.submitTask$lambda$6(holder), true);
        }
        catch (Throwable e) {
            holder.close();
            throw e;
        }
    }

    private final Map<String, State<T, R>> takeBatch() {
        Map batch = new HashMap();
        List completed = new ArrayList();
        for (State state : this.objectQueue.values()) {
            if (state.getFuture().isDone()) {
                Intrinsics.checkNotNullExpressionValue((Object)state, (String)"state");
                completed.add(state);
                continue;
            }
            if (state.getAuth() != null) continue;
            String string = state.getMeta().getOid();
            Intrinsics.checkNotNullExpressionValue((Object)state, (String)"state");
            batch.put(string, state);
            if (batch.size() < this.settings.getLimit()) continue;
        }
        for (State state : completed) {
            this.objectQueue.remove(state.getMeta().getOid(), state);
        }
        return batch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processObject(State<T, R> state, Link auth, Work<R> worker) {
        if (!Intrinsics.areEqual((Object)this.currentAuth.get(), (Object)auth)) {
            state.setAuth(null);
            return;
        }
        try {
            state.setAuth(auth);
            R result = worker.exec(auth);
            this.objectQueue.remove(state.getMeta().getOid(), state);
            state.getFuture().complete(result);
        }
        catch (UnauthorizedException e) {
            this.invalidateAuth(auth);
        }
        catch (ForbiddenException e) {
            state.onException(e, 0);
        }
        catch (Throwable e) {
            state.onException(e, this.settings.getRetryCount());
        }
        finally {
            state.setAuth(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeInPool(String name, Runnable task, Runnable finalizer, boolean pooled) {
        if (this.pool.isShutdown()) {
            this.log.warn("Thread pool is shutdown");
            Runnable runnable = finalizer;
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        if (!pooled) {
            this.log.debug("Begin: " + name);
            try {
                task.run();
            }
            catch (Throwable e) {
                this.log.error("Execute exception: " + e);
                Runnable runnable = finalizer;
                if (runnable != null) {
                    runnable.run();
                }
                throw e;
            }
            finally {
                Runnable runnable = finalizer;
                if (runnable != null) {
                    runnable.run();
                }
                this.log.debug("End: " + name);
            }
            return;
        }
        try {
            this.pool.execute(new Runnable(this, name, task, finalizer){
                final /* synthetic */ BatchWorker<T, R> this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ Runnable $task;
                final /* synthetic */ Runnable $finalizer;
                {
                    this.this$0 = $receiver;
                    this.$name = $name;
                    this.$task = $task;
                    this.$finalizer = $finalizer;
                }

                public void run() {
                    BatchWorker.access$executeInPool(this.this$0, this.$name, this.$task, this.$finalizer, false);
                }

                @NotNull
                public String toString() {
                    return this.$name;
                }
            });
        }
        catch (RejectedExecutionException e) {
            if (this.pool.isShutdown()) {
                this.log.warn("Thread pool is shutdown");
            } else {
                this.executeInPool(name, task, finalizer, false);
            }
        }
        catch (Throwable e) {
            this.log.error("Execute in pool exception: " + e);
            Runnable runnable = finalizer;
            if (runnable != null) {
                runnable.run();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void tryBatchRequest$lambda$0(int $batchId, BatchWorker this$0) {
        int newBatchId;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int curBatchId = $batchId;
        do {
            try {
                this$0.submitBatchTask();
            }
            finally {
                this$0.batchInProgress.set(0);
            }
        } while (((newBatchId = this$0.batchSequence.get()) != curBatchId || this$0.tryBatchRequestPredicate()) && this$0.batchInProgress.compareAndSet(0, curBatchId = newBatchId));
    }

    private static final void tryBatchRequest$lambda$1(BatchWorker this$0, int $batchId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.batchInProgress.compareAndSet($batchId, 0);
    }

    private static final Meta submitBatchTask$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Meta)$tmp0.invoke(p0);
    }

    private static final void submitTask$lambda$5(BatchWorker this$0, State $state, Link $auth, Work $worker) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)$auth, (String)"$auth");
        this$0.processObject($state, $auth, $worker);
    }

    private static final void submitTask$lambda$6(StateHolder $holder) {
        Intrinsics.checkNotNullParameter((Object)$holder, (String)"$holder");
        $holder.close();
    }

    public static final /* synthetic */ void access$executeInPool(BatchWorker $this, String name, Runnable task, Runnable finalizer, boolean pooled) {
        $this.executeInPool(name, task, finalizer, pooled);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0018R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00030\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lru/bozaro/gitlfs/client/internal/BatchWorker$State;", "T", "R", "", "meta", "Lru/bozaro/gitlfs/common/data/Meta;", "context", "(Lru/bozaro/gitlfs/common/data/Meta;Ljava/lang/Object;)V", "auth", "Lru/bozaro/gitlfs/common/data/Link;", "getAuth", "()Lru/bozaro/gitlfs/common/data/Link;", "setAuth", "(Lru/bozaro/gitlfs/common/data/Link;)V", "getContext", "()Ljava/lang/Object;", "Ljava/lang/Object;", "future", "Ljava/util/concurrent/CompletableFuture;", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "getMeta", "()Lru/bozaro/gitlfs/common/data/Meta;", "retry", "", "getRetry", "()I", "setRetry", "(I)V", "onException", "", "e", "", "maxRetryCount", "gitlfs-client"})
    public static final class State<T, R> {
        @NotNull
        private final Meta meta;
        private final T context;
        @NotNull
        private final CompletableFuture<R> future;
        @Nullable
        private volatile Link auth;
        private int retry;

        public State(@NotNull Meta meta, T context) {
            Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
            this.meta = meta;
            this.context = context;
            this.future = new CompletableFuture();
        }

        @NotNull
        public final Meta getMeta() {
            return this.meta;
        }

        public final T getContext() {
            return this.context;
        }

        @NotNull
        public final CompletableFuture<R> getFuture() {
            return this.future;
        }

        @Nullable
        public final Link getAuth() {
            return this.auth;
        }

        public final void setAuth(@Nullable Link link) {
            this.auth = link;
        }

        public final int getRetry() {
            return this.retry;
        }

        public final void setRetry(int n) {
            this.retry = n;
        }

        public final void onException(@NotNull Throwable e, int maxRetryCount) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            int n = this.retry;
            this.retry = n + 1;
            if (this.retry >= maxRetryCount) {
                this.future.completeExceptionally(e);
            }
            this.auth = null;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\"\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lru/bozaro/gitlfs/client/internal/BatchWorker$StateHolder;", "Ljava/lang/AutoCloseable;", "state", "Lru/bozaro/gitlfs/client/internal/BatchWorker$State;", "(Lru/bozaro/gitlfs/client/internal/BatchWorker;Lru/bozaro/gitlfs/client/internal/BatchWorker$State;)V", "stateRef", "Ljava/util/concurrent/atomic/AtomicReference;", "close", "", "gitlfs-client"})
    private final class StateHolder
    implements AutoCloseable {
        @NotNull
        private final AtomicReference<State<T, R>> stateRef;

        public StateHolder(State<T, R> state) {
            Intrinsics.checkNotNullParameter(state, (String)"state");
            this.stateRef = new AtomicReference(state);
            BatchWorker.this.objectInProgress.incrementAndGet();
        }

        @Override
        public void close() {
            State state = this.stateRef.getAndSet(null);
            if (state == null) {
                return;
            }
            State state2 = state;
            if (state2.getFuture().isDone()) {
                BatchWorker.this.objectInProgress.decrementAndGet();
                BatchWorker.this.objectQueue.remove(state2.getMeta().getOid(), state2);
            } else {
                state2.setAuth(null);
                BatchWorker.this.objectInProgress.decrementAndGet();
            }
            BatchWorker.this.stateEnqueue(false);
        }
    }
}

