/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.UnsafeKt;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.FileDataReader;
import jetbrains.exodus.io.WatchingFileDataReader;
import jetbrains.exodus.log.LogTip;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.system.JVMConstants;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B\u001d\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u001a\u001a\u00020\u00142\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\fJ\b\u0010\u001c\u001a\u00020\u0012H\u0016J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0012H\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\rH\u0016J\b\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020\u00142\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\fR\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tRD\u0010\n\u001a8\u00124\u00122\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ljetbrains/exodus/io/WatchingFileDataReader;", "Ljetbrains/exodus/io/DataReader;", "envGetter", "Lkotlin/Function0;", "Ljetbrains/exodus/env/EnvironmentImpl;", "fileDataReader", "Ljetbrains/exodus/io/FileDataReader;", "(Lkotlin/jvm/functions/Function0;Ljetbrains/exodus/io/FileDataReader;)V", "getFileDataReader$xodus_environment", "()Ljetbrains/exodus/io/FileDataReader;", "newDataListeners", "", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "prevHighAddress", "newHighAddress", "", "stopped", "", "watchKey", "Ljava/nio/file/WatchKey;", "kotlin.jvm.PlatformType", "watchService", "Ljava/nio/file/WatchService;", "addNewDataListener", "listener", "close", "doUpdate", "force", "currentThread", "Ljava/lang/Thread;", "doWatch", "getBlocks", "", "Ljetbrains/exodus/io/Block;", "fromAddress", "getLocation", "", "removeNewDataListener", "Companion", "xodus-environment"})
public final class WatchingFileDataReader
implements DataReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<EnvironmentImpl> envGetter;
    @NotNull
    private final FileDataReader fileDataReader;
    private final WatchService watchService;
    private final WatchKey watchKey;
    @NotNull
    private final Set<Function2<Long, Long, Unit>> newDataListeners;
    private volatile boolean stopped;
    private static final long DEBOUNCE_INTERVAL = 100L;
    private static final Long FORCE_CHECK_INTERVAL = Long.getLong("jetbrains.exodus.io.watching.forceCheckEach", 3000L);
    @NotNull
    private static final WatchEvent.Kind<Path>[] EVENT_KINDS;

    /*
     * WARNING - void declaration
     */
    public WatchingFileDataReader(@NotNull Function0<? extends EnvironmentImpl> envGetter, @NotNull FileDataReader fileDataReader) {
        Thread thread;
        WatchKey watchKey;
        void it;
        Intrinsics.checkNotNullParameter(envGetter, (String)"envGetter");
        Intrinsics.checkNotNullParameter((Object)((Object)fileDataReader), (String)"fileDataReader");
        this.envGetter = envGetter;
        this.fileDataReader = fileDataReader;
        this.watchService = FileSystems.getDefault().newWatchService();
        Path path = this.fileDataReader.getDir().toPath();
        WatchingFileDataReader watchingFileDataReader = this;
        boolean bl = false;
        if (JVMConstants.INSTANCE.getIS_MAC()) {
            WatchEvent.Modifier[] modifierArray = new WatchEvent.Modifier[]{SensitivityWatchEventModifier.HIGH};
            watchKey = it.register(this.watchService, EVENT_KINDS, modifierArray);
        } else {
            watchKey = it.register(this.watchService, EVENT_KINDS, new WatchEvent.Modifier[0]);
        }
        watchingFileDataReader.watchKey = watchKey;
        this.newDataListeners = new LinkedHashSet();
        Thread $this$_init__u24lambda_u2d2 = thread = new Thread(() -> WatchingFileDataReader._init_$lambda-1(this));
        boolean bl2 = false;
        $this$_init__u24lambda_u2d2.setName(Intrinsics.stringPlus((String)"Xodus watcher for ", (Object)this.getFileDataReader$xodus_environment().getDir()));
        thread.start();
    }

    @NotNull
    public final FileDataReader getFileDataReader$xodus_environment() {
        return this.fileDataReader;
    }

    @NotNull
    public String getLocation() {
        return this.fileDataReader.getLocation();
    }

    @NotNull
    public Iterable<Block> getBlocks() {
        return this.fileDataReader.getBlocks();
    }

    @NotNull
    public Iterable<Block> getBlocks(long fromAddress) {
        return this.fileDataReader.getBlocks(fromAddress);
    }

    public void close() {
        this.stopped = true;
        this.watchKey.cancel();
        this.watchService.close();
        this.fileDataReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addNewDataListener(@NotNull Function2<? super Long, ? super Long, Unit> listener) {
        boolean bl;
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Set<Function2<Long, Long, Unit>> set = this.newDataListeners;
        synchronized (set) {
            boolean bl2 = false;
            bl = this.newDataListeners.add(listener);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeNewDataListener(@NotNull Function2<? super Long, ? super Long, Unit> listener) {
        boolean bl;
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Set<Function2<Long, Long, Unit>> set = this.newDataListeners;
        synchronized (set) {
            boolean bl2 = false;
            bl = this.newDataListeners.remove(listener);
        }
        return bl;
    }

    private final void doWatch() {
        Thread currentThread = Thread.currentThread();
        long lastUpdated = 0L;
        while (!this.stopped) {
            try {
                long debounce;
                WatchKey watchKey = null;
                boolean hasFileUpdates = false;
                try {
                    List<WatchEvent<?>> events;
                    WatchKey watchKey2 = watchKey = this.watchService.poll(100L, TimeUnit.MILLISECONDS);
                    List<WatchEvent<Object>> list = events = watchKey2 == null ? null : watchKey2.pollEvents();
                    if (events == null || events.isEmpty()) {
                        long l = System.currentTimeMillis() - lastUpdated;
                        Long l2 = FORCE_CHECK_INTERVAL;
                        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"FORCE_CHECK_INTERVAL");
                        if (l <= ((Number)l2).longValue()) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)currentThread, (String)"currentThread");
                        lastUpdated = this.doUpdate(true, currentThread);
                        continue;
                    }
                    for (WatchEvent watchEvent : events) {
                        Object eventContext = watchEvent.context();
                        if (!(eventContext instanceof Path) || !LogUtil.LOG_FILE_NAME_FILTER.accept(null, ((Object)((Path)eventContext).getFileName()).toString())) continue;
                        hasFileUpdates = true;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Companion.getLogger().warn((Throwable)e, (Function0)doWatch.1.INSTANCE);
                    currentThread.interrupt();
                    return;
                }
                catch (ClosedWatchServiceException ignore) {
                    return;
                }
                if (lastUpdated > 0L && (debounce = 100L + (lastUpdated - System.currentTimeMillis())) > 5L) {
                    try {
                        Thread.sleep(debounce);
                    }
                    catch (InterruptedException interruptedException) {
                        currentThread.interrupt();
                        return;
                    }
                }
                if (hasFileUpdates) {
                    Intrinsics.checkNotNullExpressionValue((Object)currentThread, (String)"currentThread");
                    lastUpdated = this.doUpdate(false, currentThread);
                }
                if (watchKey.reset()) continue;
                Companion.getLogger().info((Function0)new Function0<Object>(currentThread){
                    final /* synthetic */ Thread $currentThread;
                    {
                        this.$currentThread = $currentThread;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Watch service is no longer valid for " + this.$currentThread.getName() + ", exiting...";
                    }
                });
                return;
            }
            catch (Throwable t) {
                if (this.stopped) continue;
                Companion.getLogger().error(t, (Function0)new Function0<Object>(currentThread){
                    final /* synthetic */ Thread $currentThread;
                    {
                        this.$currentThread = $currentThread;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$currentThread.getName();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final long doUpdate(boolean force, Thread currentThread) {
        EnvironmentImpl environmentImpl = (EnvironmentImpl)this.envGetter.invoke();
        if (environmentImpl != null) {
            EnvironmentImpl $this$doUpdate_u24lambda_u2d7 = environmentImpl;
            boolean bl = false;
            LogTip prevTip = $this$doUpdate_u24lambda_u2d7.getLog().getTip();
            if (!UnsafeKt.tryUpdate($this$doUpdate_u24lambda_u2d7)) {
                Companion.getLogger().debug((Function0)new Function0<Object>(force, $this$doUpdate_u24lambda_u2d7){
                    final /* synthetic */ boolean $force;
                    final /* synthetic */ EnvironmentImpl $this_run;
                    {
                        this.$force = $force;
                        this.$this_run = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return Intrinsics.stringPlus((String)(this.$force ? "Can't force-update env at " : "Can't update env at "), (Object)this.$this_run.getLocation());
                    }
                });
            } else {
                Companion.getLogger().debug((Function0)new Function0<Object>(force, $this$doUpdate_u24lambda_u2d7){
                    final /* synthetic */ boolean $force;
                    final /* synthetic */ EnvironmentImpl $this_run;
                    {
                        this.$force = $force;
                        this.$this_run = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return Intrinsics.stringPlus((String)(this.$force ? "Env force-updated at " : "Env updated at "), (Object)this.$this_run.getLocation());
                    }
                });
                long newHighAddress = $this$doUpdate_u24lambda_u2d7.getLog().getTip().approvedHighAddress;
                long prevHighAddress = prevTip.approvedHighAddress;
                if (newHighAddress > prevHighAddress) {
                    void $this$forEach$iv;
                    Function2[] $i$a$-synchronized-WatchingFileDataReader$doUpdate$1$42;
                    Object[] objectArray = this.newDataListeners;
                    synchronized (objectArray) {
                        boolean $i$a$-synchronized-WatchingFileDataReader$doUpdate$1$42 = false;
                        Collection $this$toTypedArray$iv = this.newDataListeners;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        Function2[] function2Array = thisCollection$iv.toArray(new Function2[0]);
                        if (function2Array == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        $i$a$-synchronized-WatchingFileDataReader$doUpdate$1$42 = function2Array;
                    }
                    objectArray = $i$a$-synchronized-WatchingFileDataReader$doUpdate$1$42;
                    boolean $i$f$forEach = false;
                    void var12_13 = $this$forEach$iv;
                    int n = 0;
                    int n2 = ((void)var12_13).length;
                    while (n < n2) {
                        void element$iv = var12_13[n];
                        ++n;
                        Function2 listener = (Function2)element$iv;
                        boolean bl2 = false;
                        try {
                            listener.invoke((Object)prevHighAddress, (Object)newHighAddress);
                        }
                        catch (Throwable t) {
                            Companion.getLogger().error(t, (Function0)new Function0<Object>(currentThread){
                                final /* synthetic */ Thread $currentThread;
                                {
                                    this.$currentThread = $currentThread;
                                    super(0);
                                }

                                @Nullable
                                public final Object invoke() {
                                    return Intrinsics.stringPlus((String)"New data listener failed for ", (Object)this.$currentThread.getName());
                                }
                            });
                        }
                    }
                }
            }
        }
        return System.currentTimeMillis();
    }

    private static final void _init_$lambda-1(WatchingFileDataReader this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doWatch();
    }

    static {
        WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE};
        EVENT_KINDS = kindArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R:\u0010\u0005\u001a,\u0012(\u0012&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0018\u0010\u000b\u001a\n \t*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\r"}, d2={"Ljetbrains/exodus/io/WatchingFileDataReader$Companion;", "Lmu/KLogging;", "()V", "DEBOUNCE_INTERVAL", "", "EVENT_KINDS", "", "Ljava/nio/file/WatchEvent$Kind;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "[Ljava/nio/file/WatchEvent$Kind;", "FORCE_CHECK_INTERVAL", "Ljava/lang/Long;", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

