/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.cache;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class VarLengthInputStream
implements Closeable {
    private final DataInputStream in;

    public VarLengthInputStream(byte[] input) {
        this.in = new DataInputStream(new ByteArrayInputStream(input));
    }

    public String readUTF() throws IOException {
        int length = this.readInt();
        byte[] bytes = new byte[length];
        this.in.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public int readInt() throws IOException {
        byte b;
        int result = 0;
        int shift = 0;
        do {
            b = this.readByte();
            result |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return result;
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

