/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1145")
public class IfConditionAlwaysTrueOrFalseCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1145";
    private static final String MESSAGE = "Remove this \"if\" statement.";

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        ExpressionTree condition = tree.condition().expression();
        if (condition.is(Tree.Kind.BOOLEAN_LITERAL)) {
            this.context().newIssue(this, tree.ifToken(), tree.condition(), MESSAGE);
        }
        super.visitIfStatement(tree);
    }
}

