/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.connectors;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationBase;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorModuleBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.rollback.PostRevisionAnalysisTriggerBase;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public abstract class ConnectorDescriptorBase
extends ConfigurationBase
implements Comparable<ConnectorDescriptorBase> {
    private static final Pattern CONNECTOR_IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+");
    public final EConnectorType connectorType;
    public final IConnectorEnum<?> connectorEnum;
    @JsonIgnore
    private final Map<String, ConfigOptionDescriptorBase> optionByName = new HashMap<String, ConfigOptionDescriptorBase>();
    private InternalProjectId projectId;
    private ConfigurationInitializationContext context;
    private boolean configured = false;
    private boolean initialized = false;

    protected ConnectorDescriptorBase(IConnectorEnum<?> connectorEnum, EConnectorType connectorType) {
        this.connectorType = connectorType;
        this.connectorEnum = connectorEnum;
    }

    public String getName() {
        return this.connectorEnum.getReadableName();
    }

    public EConnectorType getConnectorType() {
        return this.connectorType;
    }

    public String getDescription() {
        return this.connectorEnum.getDescription();
    }

    public @Nullable String getLongDescription() {
        return this.connectorEnum.getLongDescription();
    }

    public String getUrl() {
        return this.connectorEnum.getWebsiteUrl();
    }

    public String getLogoUrl() {
        return this.connectorEnum.getLogoUrl();
    }

    public Boolean isBeta() {
        return this.connectorEnum.isBeta();
    }

    @Override
    protected void addOption(ConfigOptionDescriptorBase option) {
        super.addOption(option);
        this.optionByName.put(option.getName(), option);
    }

    public ConfigOptionDescriptorBase getOptionByName(String name) {
        return this.optionByName.get(name);
    }

    @Override
    public int compareTo(ConnectorDescriptorBase other) {
        return this.getName().compareTo(other.getName());
    }

    protected void checkNotEmpty(List<String> list, String name) throws ProjectConfigurationException {
        if (list.isEmpty()) {
            throw new ProjectConfigurationException("Error: list " + name + this.getFormattedErrorLocation() + " may not be empty!");
        }
    }

    protected void checkNotEmpty(String value, String name) throws ProjectConfigurationException {
        if (StringUtils.isEmpty((String)value)) {
            throw new ProjectConfigurationException("Error: value " + name + this.getFormattedErrorLocation() + " may not be empty!");
        }
    }

    protected void checkNonNegative(double value, String name) throws ProjectConfigurationException {
        if (value < 0.0) {
            throw new ProjectConfigurationException("Error: value " + name + this.getFormattedErrorLocation() + " may not be negative!");
        }
    }

    private String getFormattedErrorLocation() {
        String errorLocation = this.getErrorLocation();
        if (StringUtils.isEmpty((String)errorLocation)) {
            return "";
        }
        return " in " + errorLocation;
    }

    protected String getErrorLocation() {
        return null;
    }

    public void validate() throws ConnectorValidationException {
        this.validateConnectorIdentifier();
        this.validateComponents();
    }

    private void validateComponents() throws ConnectorValidationException {
        for (ConnectorModuleBase connectorModule : this.getConnectorModules()) {
            connectorModule.validate(this.getContext());
        }
    }

    private void validateConnectorIdentifier() throws ConnectorValidationException {
        String connectorIdentifier = this.getConnectorIdentifier();
        if (StringUtils.isEmpty((String)connectorIdentifier)) {
            throw new ConnectorValidationException(String.format("%s must be present", this.getConnectorIdentifierOptionName()));
        }
        if (!CONNECTOR_IDENTIFIER_PATTERN.matcher(connectorIdentifier).matches()) {
            throw new ConnectorValidationException(String.format("%s may not be empty or contain invalid characters. Must match %s", this.getConnectorIdentifierOptionName(), CONNECTOR_IDENTIFIER_PATTERN.pattern()));
        }
    }

    public final void storeConfigurationData(ProjectStorageSystem projectStorageSystem) throws StorageException, ConnectorValidationException {
        CCSMAssert.isTrue((boolean)this.configured, (String)"Can not store connector configuration of a non-configured connector!");
        this.storeConfigurationDataInternal(projectStorageSystem);
    }

    protected abstract void storeConfigurationDataInternal(ProjectStorageSystem var1) throws StorageException, ConnectorValidationException;

    public abstract void deleteConfigurationData(ProjectStorageSystem var1, String var2) throws StorageException, ConnectorValidationException;

    public abstract String getConnectorIdentifier();

    public abstract String getConnectorIdentifierOptionName();

    public InternalProjectId getProjectId() {
        return this.projectId;
    }

    public void setProjectId(InternalProjectId projectId) {
        this.projectId = projectId;
    }

    protected static void ensureSchedulingHintIsPresent(Class<?> trigger, EAnalysisStepParameter hint) {
        block3: {
            block2: {
                AnalysisStep schedulingHints = trigger.getAnnotation(AnalysisStep.class);
                if (schedulingHints == null) break block2;
                if (!Arrays.stream(schedulingHints.hints()).noneMatch(hint::equals)) break block3;
            }
            CCSMAssert.fail((String)"Class \"%s\" should have the \"%s\" scheduling hint set!".formatted(new Object[]{trigger.getName(), hint}));
        }
    }

    public final void init(ConfigurationInitializationContext context) {
        Objects.requireNonNull(context, "context");
        if (this.context != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.context = context;
        this.initInternal();
        this.initialized = true;
    }

    @VisibleForTesting
    public boolean isInitialized() {
        return this.initialized;
    }

    protected final ConfigurationInitializationContext getContext() {
        if (this.context == null) {
            throw new IllegalStateException("No context provided, init not called!");
        }
        return this.context;
    }

    protected void initInternal() {
    }

    @Override
    public final void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.configureIndices(IIndexCreator.of(proxy));
        this.configureTriggers(ITriggerCreator.of(proxy));
        this.configured = true;
    }

    protected void configureIndices(IIndexCreator indexCreator) {
    }

    protected void configureTriggers(ITriggerCreator triggerCreator) throws ProjectConfigurationException {
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public static sealed interface IIndexCreator
    permits DelegatingIndexCreator {
        public void createProjectIndex(Class<? extends IProjectIndex> var1);

        public void createProjectIndex(Class<? extends IProjectIndexWithDynamicName> var1, String var2);

        public boolean isProjectIndexAlreadyCreated(Class<? extends IProjectIndex> var1);

        private static IIndexCreator of(ProjectCreationProxy proxy) {
            return new DelegatingIndexCreator(proxy);
        }
    }

    public static sealed interface ITriggerCreator
    permits DelegatingTriggerCreator {
        public Set<ELanguage> getConfiguredLanguages();

        public String createTrigger(TriggerBuilder var1) throws ProjectConfigurationException;

        public String createTrigger(TriggerBuilder var1, String var2) throws ProjectConfigurationException;

        public boolean isTriggerAlreadyCreated(String var1);

        public void addMetaIndexEntry(MetaIndex.IMetaIndexEntry var1) throws ProjectConfigurationException;

        public boolean isMetaIndexEntryAlreadyAdded(MetaIndex.IMetaIndexEntry var1);

        public void addMetaIndexStringValue(String var1, String var2) throws ProjectConfigurationException;

        public void addPostRevisionAnalysisTrigger(EAnalysisState var1, Class<? extends PostRevisionAnalysisTriggerBase> var2);

        public void addPostBuildCompletenessAnalysisTrigger(String var1);

        public ProjectConfiguration getNewProjectConfiguration();

        public @Nullable List<AnalysisTrigger> getPreviousTriggers();

        public Optional<ConnectorConfiguration> getConnectorFromPreviousConfiguration(String var1);

        public void addMetaIndexExternalLinkTemplates(String var1, String var2, String var3) throws ProjectConfigurationException;

        public List<CodeScope> getCodeScopes();

        @VisibleForTesting
        public static ITriggerCreator of(ProjectCreationProxy proxy) {
            return new DelegatingTriggerCreator(proxy);
        }
    }

    private record DelegatingTriggerCreator(ProjectCreationProxy proxy) implements ITriggerCreator
    {
        @Override
        public Set<ELanguage> getConfiguredLanguages() {
            return this.proxy.getAllConfiguredLanguages();
        }

        @Override
        public String createTrigger(TriggerBuilder triggerBuilder) throws ProjectConfigurationException {
            return this.proxy.createTrigger(triggerBuilder);
        }

        @Override
        public String createTrigger(TriggerBuilder triggerBuilder, String namePrefix) throws ProjectConfigurationException {
            return this.proxy.createTrigger(triggerBuilder, namePrefix);
        }

        @Override
        public boolean isTriggerAlreadyCreated(String triggerName) {
            return this.proxy.isTriggerAlreadyCreated(triggerName);
        }

        @Override
        public boolean isMetaIndexEntryAlreadyAdded(MetaIndex.IMetaIndexEntry metaIndexEntry) {
            return this.proxy.isMetaIndexEntryAlreadyAdded(metaIndexEntry);
        }

        @Override
        public void addMetaIndexEntry(MetaIndex.IMetaIndexEntry entry) throws ProjectConfigurationException {
            this.proxy.addMetaIndexEntry(entry);
        }

        @Override
        public void addMetaIndexStringValue(String key, String value) throws ProjectConfigurationException {
            this.proxy.addMetaIndexStringValue(key, value);
        }

        @Override
        public void addPostRevisionAnalysisTrigger(EAnalysisState analysisState, Class<? extends PostRevisionAnalysisTriggerBase> trigger) {
            this.proxy.addPostRevisionAnalysisTrigger(analysisState, trigger);
        }

        @Override
        public void addPostBuildCompletenessAnalysisTrigger(String triggerName) {
            this.proxy.addPostBuildCompletenessAnalysisTrigger(triggerName);
        }

        @Override
        public ProjectConfiguration getNewProjectConfiguration() {
            return this.proxy.getNewProjectConfiguration();
        }

        @Override
        public @Nullable List<AnalysisTrigger> getPreviousTriggers() {
            return this.proxy.getPreviousTriggers();
        }

        @Override
        public Optional<ConnectorConfiguration> getConnectorFromPreviousConfiguration(String connectorIdentifier) {
            return this.proxy.getConnectorFromPreviousConfiguration(connectorIdentifier);
        }

        @Override
        public void addMetaIndexExternalLinkTemplates(String connectorIdentifier, String commitLinkTemplate, String commitInMergeRequestLinkTemplate) throws ProjectConfigurationException {
            this.proxy.addMetaIndexExternalLinkTemplates(connectorIdentifier, commitLinkTemplate, commitInMergeRequestLinkTemplate);
        }

        @Override
        public List<CodeScope> getCodeScopes() {
            return this.proxy.getCodeScopes();
        }
    }

    private record DelegatingIndexCreator(ProjectCreationProxy proxy) implements IIndexCreator
    {
        @Override
        public void createProjectIndex(Class<? extends IProjectIndex> indexClass) {
            this.proxy.createProjectIndex(indexClass);
        }

        @Override
        public void createProjectIndex(Class<? extends IProjectIndexWithDynamicName> indexClass, String indexName) {
            this.proxy.createProjectIndex(indexClass, indexName);
        }

        @Override
        public boolean isProjectIndexAlreadyCreated(Class<? extends IProjectIndex> indexClass) {
            return this.proxy.isProjectIndexAlreadyCreated(indexClass);
        }
    }
}

