/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.aws;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="aws.credentials.process.variable", name="Environment Variables (Added to command environment)", type=EOptionType.SERVER, category=EOptionCategory.AWS, multiOption=true, orderingHint=500)
@IndexValueClass(containedInBackup=true)
public class AwsCredentialProcessVariableDefinition
implements IOption {
    static final String VARIABLE_NAME_ERROR_MESSAGE = "Environment variable names must contain only alphanumeric characters and underscores, and must not start with a number";
    public static final String OPTION_ID = "aws.credentials.process.variable";
    public static final String OPTION_NAME = "Environment Variables (Added to command environment)";
    private static final long serialVersionUID = -7384471361493022042L;
    private static final Pattern VALID_VARIABLE_NAME_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z_\\d]*");
    @JsonProperty(value="name")
    @OptionFieldDescription(name="Name of this environment variable")
    public String name = "";
    @JsonProperty(value="value")
    @OptionFieldDescription(name="Value of this environment variable")
    @PasswordOption
    public String value = "";

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        Matcher matcher = VALID_VARIABLE_NAME_PATTERN.matcher(this.name);
        if (!matcher.matches()) {
            return String.format("%s: %s", VARIABLE_NAME_ERROR_MESSAGE, this.name);
        }
        return null;
    }
}

