/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.migrators.ReportSlideMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedBooleanField;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.objects.SerializedClassValues;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.utils.SerializationMigrationUtils;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion108AddHideThresholdParameter
extends ReportSlideMigratorBase {
    private static final String METRIC_BAR_CHART_SLIDE_CLASS = "com.teamscale.index.quality_report.slides.MetricBarChartSlide";
    private static final String METRIC_BAR_CHART_SLIDE_PARAMETER_CLASS = "com.teamscale.index.quality_report.slides.MetricBarChartSlide$MetricBarChartSlideParameters";
    private static final String HIDE_TARGET_THRESHOLD_PARAMETER_NAME = "hideTargetThreshold";

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V108;
    }

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        for (SerializedObject metricBarChartSlide : SerializedEntityUtils.findInstancesOf((SerializedClass)entityPool.findClass(METRIC_BAR_CHART_SLIDE_CLASS), (SerializedEntityPool)entityPool)) {
            this.addParameterFieldInClass(entityPool);
            SerializedObject slideParameters = (SerializedObject)entityPool.getEntity(((Integer)metricBarChartSlide.getFieldValue("slideParameters")).intValue(), SerializedObject.class);
            slideParameters.setFieldValue(HIDE_TARGET_THRESHOLD_PARAMETER_NAME, (Object)false);
            SerializedObject slideParameterDescriptorsObject = (SerializedObject)entityPool.getEntity(((Integer)slideParameters.getFieldValue("parameterDescriptors")).intValue(), SerializedObject.class);
            SerializedClass listClass = SerializationMigrationUtils.findClassInHierarchy((SerializedObject)slideParameterDescriptorsObject, ArrayList.class);
            SerializedClassValues fieldSets = slideParameterDescriptorsObject.getFieldSet(slideParameterDescriptorsObject.getPlainClassHierarchy().indexOf(listClass));
            SerializedObject newParameterDescriptor = MigrateVersion108AddHideThresholdParameter.createParameterDescriptorObject(entityPool, HIDE_TARGET_THRESHOLD_PARAMETER_NAME, "Hide target threshold", "BOOLEAN", "");
            fieldSets.getPostFieldData().add(4, newParameterDescriptor.getHandle());
            fieldSets.setValue(0, (Object)5);
            SerializedObject updatedParameterDescriptors = new SerializedObject(slideParameterDescriptorsObject.getClassHandle(), Collections.singletonList(fieldSets), entityPool);
            slideParameters.setFieldValue("parameterDescriptors", (Object)updatedParameterDescriptors.getHandle());
        }
    }

    private void addParameterFieldInClass(SerializedEntityPool entityPool) {
        SerializedClass serializedClass = entityPool.findClass(METRIC_BAR_CHART_SLIDE_PARAMETER_CLASS);
        if (serializedClass == null) {
            return;
        }
        if (!serializedClass.containsField(HIDE_TARGET_THRESHOLD_PARAMETER_NAME)) {
            serializedClass.addField((SerializedFieldBase)new SerializedBooleanField(HIDE_TARGET_THRESHOLD_PARAMETER_NAME));
        }
    }
}

