/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StoreBase;
import org.conqat.engine.persistence.store.capability.IStoreCapability;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="virtual-stores", options={EStorageOption.COMPRESSED}, valueClasses={byte[].class})
public class VirtualStoreIndex
extends IndexBase
implements IGlobalIndex {
    public static final String INDEX_NAME = "virtual-stores";

    public VirtualStoreIndex(IStore store) {
        super(store);
    }

    public IStore openVirtualStoreForReading(List<Long> ids) {
        return new VirtualReadingStore(ids);
    }

    public IStore openVirtualStoreForWriting(long id) {
        return new VirtualWritingStore(id);
    }

    public void discardVirtualStores(Collection<Long> ids) throws StorageException {
        for (long id : ids) {
            this.store.removeByPrefix(ByteArrayUtils.longToByteArray((long)id));
        }
    }

    private class VirtualReadingStore
    extends VirtualStoreBase {
        private final List<Long> ids;

        private VirtualReadingStore(List<Long> ids) {
            super(String.valueOf(ids.get(0)) + "-");
            this.ids = ids;
        }

        public byte[] get(byte @NonNull [] key) throws StorageException {
            List values = VirtualStoreIndex.this.store.get(CollectionUtils.map(this.ids, id -> VirtualReadingStore.prependId(id, key)));
            return values.stream().filter(Objects::nonNull).findFirst().orElseThrow(() -> new StorageException("May not read non-existing values from a virtual index!"));
        }

        public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
            ArrayList<byte[]> expandedKeys = new ArrayList<byte[]>();
            for (byte[] key : keys) {
                for (long id : this.ids) {
                    expandedKeys.add(VirtualReadingStore.prependId(id, key));
                }
            }
            List expandedValues = VirtualStoreIndex.this.store.get(expandedKeys);
            ArrayList<byte[]> result = new ArrayList<byte[]>(keys.size());
            for (int i = 0; i < keys.size(); ++i) {
                byte[] value = null;
                for (int j = 0; j < this.ids.size() && value == null; ++j) {
                    value = (byte[])expandedValues.get(i * this.ids.size() + j);
                }
                if (value == null) {
                    throw new StorageException("May not read non-existing values from a virtual index!");
                }
                result.add(value);
            }
            return result;
        }

        public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
            throw new StorageException("May not write data into a virtual store opened for reading!");
        }

        public void remove(byte @NonNull [] key) throws StorageException {
            throw new StorageException("May not write data into a virtual store opened for reading!");
        }
    }

    private class VirtualWritingStore
    extends VirtualStoreBase {
        private final long id;

        private VirtualWritingStore(long id) {
            super(id + "-");
            this.id = id;
        }

        public byte[] get(byte @NonNull [] key) throws StorageException {
            throw new StorageException("May not read data from a virtual index opened for writing!");
        }

        public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
            VirtualStoreIndex.this.store.put(VirtualWritingStore.prependId(this.id, key), value);
        }

        public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
            VirtualStoreIndex.this.store.put(keysValues.mapFirst(key -> VirtualWritingStore.prependId(this.id, key)));
        }

        public void remove(byte @NonNull [] key) throws StorageException {
            VirtualStoreIndex.this.store.remove(VirtualWritingStore.prependId(this.id, key));
        }

        public void remove(List<byte @NonNull []> keys) throws StorageException {
            VirtualStoreIndex.this.store.remove(CollectionUtils.map(keys, key -> VirtualWritingStore.prependId(this.id, key)));
        }

        public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
            throw new StorageException("May not remove by prefix from a virtual index opened for writing!");
        }
    }

    private abstract class VirtualStoreBase
    extends StoreBase {
        private final String lockPrefix;

        protected VirtualStoreBase(String lockPrefix) {
            this.lockPrefix = lockPrefix;
        }

        protected static byte[] prependId(long id, byte[] key) {
            return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.longToByteArray((long)id), key});
        }

        public void scan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
            throw new StorageException("May not perform scanning in a virtual index!");
        }

        public void scanKeys(byte @Nullable [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
            throw new StorageException("May not perform scanning in a virtual index!");
        }

        public Lock obtainLock(String suffix) {
            return VirtualStoreIndex.this.store.obtainLock(this.lockPrefix + suffix);
        }

        public <T extends IStoreCapability> Optional<T> getCapability(Class<T> capability) {
            return VirtualStoreIndex.this.store.getCapability(capability);
        }
    }
}

