

Encryption in general is typically critical to the security of many
applications.  Using SSH can greatly increase security by guaranteeing the
identity of the party you are communicating with.  This is accomplished by one
or both parties presenting trusted host keys during the connection
initialization phase of SSH.

When paramiko methods are used, host keys are verified by default. If host key
verification is disabled, Bandit will return a HIGH severity error.

## Example

``` python

>> Issue: [B507:ssh_no_host_key_verification] Paramiko call with policy set
to automatically trust the unknown host key.
Severity: High   Confidence: Medium
CWE: CWE-295 (https://cwe.mitre.org/data/definitions/295.html)
Location: examples/no_host_key_verification.py:4
3   ssh_client = client.SSHClient()
4   ssh_client.set_missing_host_key_policy(client.AutoAddPolicy)
5   ssh_client.set_missing_host_key_policy(client.WarningPolicy)


```
New in version  1.5.1

Changed in version  1.7.3
CWE information added

