

Paramiko is a Python library designed to work with the SSH2 protocol for secure
(encrypted and authenticated) connections to remote machines. It is intended to
run commands on a remote host. These commands are run within a shell on the
target and are thus vulnerable to various shell injection attacks. Bandit
reports a MEDIUM issue when it detects the use of Paramiko's "exec_command"
method advising the user to check inputs are correctly sanitized.

## Example

``` python

>> Issue: Possible shell injection via Paramiko call, check inputs are
properly sanitized.
Severity: Medium   Confidence: Medium
CWE: CWE-78 (https://cwe.mitre.org/data/definitions/78.html)
Location: ./examples/paramiko_injection.py:4
3    # this is not safe
4    paramiko.exec_command('something; really; unsafe')
5

```
## see also:

- https://security.openstack.org
- https://github.com/paramiko/paramiko
- https://www.owasp.org/index.php/Command_Injection
- https://cwe.mitre.org/data/definitions/78.html

New in version  0.12.0

Changed in version  1.7.3
CWE information added

