`from module import *` is discouraged because the programmer often won't know where an imported object is defined. The imported module, class, or function should be explicitly defined.

### Anti-pattern

In the following example, it is unclear whether the `User` class is defined in the `users.models` module or the `auth.models` module.

```python
from users.models import *
from auth.models import *

user = User.objects.get(name='Grant')
```

### Best practice

```python
from users.models import User
from auth.models import check_password

user = User.objects.get(name='Grant')
check_password(user.username, 'password')
```
