<h2>Why is this an issue?</h2>
<p>Inheritance is one of the most valuable concepts in object-oriented programming. It’s a way to categorize and reuse code by creating collections of
attributes and behaviors called classes, which can be based on previously created classes.</p>
<p>But abusing this concept by creating a deep inheritance tree can lead to complex and unmaintainable source code. Often, an inheritance tree
becoming too deep is the symptom of systematic use of "inheritance" when other approaches like "composition" would be better suited.</p>
<p>This rule raises an issue when the inheritance tree, starting from <code>Object</code>, has a greater depth than is allowed.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<p><a href="https://en.wikipedia.org/wiki/Composition_over_inheritance">Composition over inheritance: difference between composition and inheritance
in object-oriented programming</a></p>

