﻿## SA1501

<table>
<tr>
  <td>TypeName</td>
  <td>SA1501StatementMustNotBeOnSingleLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1501</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

A C# statement containing opening and closing braces is written completely on a single line.

## Rule description

A violation of this rule occurs when a statement that is wrapped in opening and closing braces is written on a single line. For example:

```csharp
public object Method()
{
    lock (this) { return this.value; }
}
```

When StyleCop checks this code, a violation of this rule will occur because the entire lock statement is written on one line. The statement should be written across multiple lines, with the opening and closing braces each on their own line, as follows:

```csharp
public object Method()
{
    lock (this) 
    {
        return this.value; 
    }
}
```

## How to fix violations

To fix a violation of this rule, rewrite the statement so that it expands across multiple lines.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1501:StatementMustNotBeOnSingleLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1501 // StatementMustNotBeOnSingleLine
#pragma warning restore SA1501 // StatementMustNotBeOnSingleLine
```
