﻿## SA1513

<table>
<tr>
  <td>TypeName</td>
  <td>SA1513ClosingBraceMustBeFollowedByBlankLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1513</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

A closing brace within a C# element, statement, or expression is not followed by a blank line.

## Rule description

To improve the readability of the code, StyleCop requires blank lines in certain situations, and prohibits blank lines
in other situations. This results in a consistent visual pattern across the code, which can improve recognition and
readability of unfamiliar code.

A violation of this rule occurs when a closing brace is not followed by a blank line. For example, the following code
would generate one instance of this violation, since there is one place where a closing brace is not followed by a blank
line.

```csharp
if (condition)
{
    DoSomething();
}
return value;
```


## How to fix violations

To fix a violation of this rule, ensure a blank line follows closing braces.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1513:ClosingBraceMustBeFollowedByBlankLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1513 // ClosingBraceMustBeFollowedByBlankLine
#pragma warning restore SA1513 // ClosingBraceMustBeFollowedByBlankLine
```
