<h2>Why is this an issue?</h2>
<p>Creating multiline strings by using a backslash (<code>\</code>) before a newline is known as "line continuation" or "line breaking." While it may
seem like a convenient way to format multiline strings, it is generally considered bad practice.</p>
<ul>
  <li> Line continuation can make the code harder to read and understand, especially when dealing with long strings. It introduces an extra character
  at the end of each line, which can clutter the code and reduce its readability. </li>
  <li> If the string content changes, it might require reformatting the entire multiline string, involving adjusting the line breaks and ensuring the
  backslashes are correctly placed. This can be error-prone and cumbersome, leading to maintenance issues. </li>
  <li> Line continuation can sometimes behave unexpectedly, particularly when there are trailing spaces or tabs after the backslash. This can lead to
  subtle bugs that are difficult to spot and debug. </li>
</ul>

```js
let myString = 'A rather long string of English text, an error message \
                actually that just keeps going and going -- an error \
                message to make the Energizer bunny blush (right through \
                those Schwarzenegger shades)! Where was I? Oh yes, \
                you\'ve got an error and all the extraneous whitespace is \
                just gravy.  Have a nice day.';  // Noncompliant
```
<p>Instead, you should use string concatenation for multiline strings, which involves combining multiple strings to create a single string that spans
multiple lines.</p>

```js
let myString = 'A rather long string of English text, an error message ' +
               'actually that just keeps going and going -- an error ' +
               'message to make the Energizer bunny blush (right through ' +
               'those Schwarzenegger shades)! Where was I? Oh yes, ' +
               'you\'ve got an error and all the extraneous whitespace is ' +
               'just gravy.  Have a nice day.';
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Expressions_and_operators#string_operators">String
  operators</a> </li>
</ul>