<h2>Why is this an issue?</h2>
<p>When a test fails due, for example, to infrastructure issues, you might want to ignore it temporarily. But without some kind of notation about why
the test is being ignored, it may never be reactivated. Such tests are difficult to address without comprehensive knowledge of the project, and end up
polluting their projects.</p>
<p>This rule raises an issue on each test that is marked as incomplete or skipped without a message explaining the reasoning behind it.</p>
<h3>Noncompliant code example</h3>

```php
protected function setUp() {
  if (!extension_loaded('mysqli')) {
    $this->markTestSkipped(); // Noncompliant
  }
}

public function testSomething()
{
  $this->assertTrue($result->isValid());
  $this->markTestIncomplete(); // Noncompliant
}
```
<h3>Compliant solution</h3>

```php
protected function setUp() {
  if (!extension_loaded('mysqli')) {
    $this->markTestSkipped( 'The MySQLi extension is not available.' ); // Compliant
  }
}

public function testSomething()
{
  $this->assertTrue($result->isValid());
  $this->markTestIncomplete( 'Testing result validation is incomplete.' ); // Compliant
}
```