"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureTemplateParser = exports.getTemplateParserServices = void 0;
function getTemplateParserServices(context) {
    ensureTemplateParser(context);
    return context.parserServices;
}
exports.getTemplateParserServices = getTemplateParserServices;
/**
 * Utility for rule authors to ensure that their rule is correctly being used with @angular-eslint/template-parser
 * If @angular-eslint/template-parser is not the configured parser when the function is invoked it will throw
 */
function ensureTemplateParser(context) {
    var _a, _b;
    if (!((_a = context.parserServices) === null || _a === void 0 ? void 0 : _a.convertNodeSourceSpanToLoc) ||
        !((_b = context.parserServices) === null || _b === void 0 ? void 0 : _b.convertElementSourceSpanToLoc)) {
        /**
         * The user needs to have configured "parser" in their eslint config and set it
         * to @angular-eslint/template-parser
         */
        throw new Error("You have used a rule which requires '@angular-eslint/template-parser' to be used as the 'parser' in your ESLint config.");
    }
}
exports.ensureTemplateParser = ensureTemplateParser;
