This check detects `#endif` directives without a comment that contains the condition of the respective `#if` directive.

# Why is This a Problem?

It can be extremely valuable to have comments on the `#endif` lines to clearly identify region boundaries of the conditional preprocessing blocks.

# How Can I Resolve This?

Add the missing in-line comment after the `#endif` directive.

## Example (Before)

```CPP
#if FEATURE_TOGGLE_A
  // Some conditionally included code
  // ...
#endif
```

## Example (After)

```CPP
#if FEATURE_TOGGLE_A
  // Some conditionally included code
  // ...
#endif // FEATURE_TOGGLE_A
```

# Where Can I Learn More?

## Guidelines

- [C++ reference: Conditional inclusion](https://en.cppreference.com/w/cpp/preprocessor/conditional)