The return statement contains a post-increment or post-decrement on a local variable in a return statement, without effect on the value of the expression.


# Why is This a Problem?

A post-operator on a local variable that is not read, has no effect and does not change the returned value.
In most cases this is a mistake, and a different expression was intended 
(e.g. `return x+1` instead of `return x++`).

# How Can I Resolve This?
Please verify, that this statement does what it should. In case the statement's value should be changed before returning, use pre-increments/pre-decrements or arithmetic expressions. In case the value should not change, remove the post-increment/post-decrement.
## Example (Before)

``` java
int foo() {
    x = 3;
    return x--;
}
```

## Example (After)


``` java
int foo() {
    x = 3;
    return --x;
}
```

