JUnit5 test classes and methods should generally not be public but have default package visibility.
Instead, remove the public or protected keywords to achieve package-private visibility.

# What Does This Check Look For?

This check searches for JUnit5 test classes and methods declared with public or protected visibility modifiers, reporting a finding when such modifiers are present, as these are unnecessary and reduce readability.

# Why is This a Problem?

Using public or protected visibility for JUnit5 test classes and methods is non-conventional and can hinder readability.
JUnit5 allows non-public test classes and methods, unlike JUnit4, promoting better encapsulation and cleaner code structures.
Moreover, private methods are ignored by JUnit5 unless managed properly, potentially affecting test reliability.

# How Can I Resolve This?

Simply modify the code by removing the public or protected visibility keywords from test classes and methods, aligning them with JUnit5's recommendations for default package visibility, thus improving readability and maintaining conventional code structure.

# Examples
## Non-Compliant

```java
import org.junit.jupiter.api.Test;

public class MyClassTest { // non-compliant: modifier can be removed
  @Test
  protected void test() { // non-compliant: modifier can be removed
    // ...
  }
}
```

## Compliant

```java
import org.junit.jupiter.api.Test;

class MyClassTest { // compliant: default package visibility
  @Test
  void test() { // compliant: default package visibility
    // ...
  }
}
```

# Where Can I Learn More?
- [JUnit5 User Guide: Test Classes and Methods](https://junit.org/junit5/docs/current/user-guide/#writing-tests-classes-and-methods)

