/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.util;

import java.io.File;
import java.io.IOException;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.xml.IXMLResolver;
import org.conqat.lib.commons.xml.XMLReader;
import org.conqat.lib.commons.xml.XMLResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLReaderBase<E extends Enum<E>, A extends Enum<A>, X extends Exception>
extends XMLReader<E, A, X> {
    public XMLReaderBase(String content, Class<A> attributeClass) {
        this(content, (IXMLResolver<E, A>)new XMLResolver(attributeClass));
    }

    public XMLReaderBase(String content, IXMLResolver<E, A> resolver) {
        super(content, resolver);
    }

    public XMLReaderBase(File file, IXMLResolver<E, A> resolver) throws IOException {
        super(file, resolver);
    }

    protected void parseAndWrapExceptions() throws ConQATException {
        try {
            this.parseFile();
        }
        catch (SAXParseException e) {
            throw new ConQATException("XML parsing exception at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " (" + e.getMessage() + ") in element at " + this.getLocation(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new ConQATException("XML parsing exception: " + e.getMessage() + " in element at " + this.getLocation(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ConQATException("Element at " + this.getLocation() + " could not be read: " + e.getMessage(), (Throwable)e);
        }
    }

    protected abstract String getLocation();
}

