/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.ESubjectType;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EBasicRole;
import com.teamscale.core.user.User;
import com.teamscale.index.dashboard.templates.DashboardTemplateDescriptor;
import com.teamscale.index.user.UserAliasLookup;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.jspecify.annotations.Nullable;

@NoIndexValueClass(rationale="Only used as service DTO")
public class UserResolvedDashboardTemplateDescriptor
extends DashboardTemplateDescriptor {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="resolvedOwner")
    private final @Nullable User resolvedOwner;
    @JsonProperty(value="canEdit")
    private final boolean canEdit;

    public UserResolvedDashboardTemplateDescriptor(DashboardTemplateDescriptor template, UserAliasLookup userAliasLookup, PermissionIndex permissionIndex, ServicePermissions permissions) throws StorageException {
        this.id = template.getId();
        this.description = template.description;
        this.name = template.name;
        this.setDescriptor(template.getDescriptor());
        this.canEdit = permissions.hasBasicPermission(EBasicPermissionScope.DASHBOARD_TEMPLATES, this.id.toString(), EBasicPermission.EDIT);
        this.owner = permissionIndex.getBasicRoles(EBasicPermissionScope.DASHBOARD_TEMPLATES, this.id.toString()).stream().filter(role -> !role.isGlobal && role.subjectType == ESubjectType.USER && role.roleName.equals(EBasicRole.OWNER.getReadableName())).map(role -> role.subjectId).findFirst().orElse(null);
        this.resolvedOwner = userAliasLookup.resolveUser(this.owner).orElse(null);
    }

    public static List<UserResolvedDashboardTemplateDescriptor> resolveUsers(List<? extends DashboardTemplateDescriptor> templates, UserAliasLookup userAliasLookup, PermissionIndex permissionIndex, ServicePermissions permissions) throws StorageException {
        return CollectionUtils.mapWithException(templates, template -> new UserResolvedDashboardTemplateDescriptor((DashboardTemplateDescriptor)template, userAliasLookup, permissionIndex, permissions));
    }

    private void readObject(ObjectInputStream in) {
        SerializationUtils.unsupportedReadObject((ObjectInputStream)in);
    }

    private void writeObject(ObjectOutputStream out) {
        SerializationUtils.unsupportedWriteObject((ObjectOutputStream)out);
    }
}

