/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.testgap.TeamscaleIssueWithTgaInfo;
import com.teamscale.service.testgap.TgaSummary;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@ExportToTypeScript
public enum EIssuesExportFormat {
    CSV(MoreMediaTypes.TEXT_CSV_TYPE, "csv"){

        @Override
        public String createPayload(List<TeamscaleIssueWithTgaInfo> issues, PublicProjectId projectId) {
            StringBuilder builder = new StringBuilder();
            ArrayList<Object> columns = new ArrayList<Object>(Arrays.asList("Issue ID", "Subject", "Status", "Assignee", "# Changes", "Test Gap", "# Test Gaps"));
            1.writeCsvRow(builder, columns);
            for (TeamscaleIssueWithTgaInfo issue : issues) {
                TgaSummary tgaSummary = issue.getTgaSummary();
                int numberOfChanges = tgaSummary.getTotalStates();
                double testGapRatio = numberOfChanges == 0 ? Double.NaN : tgaSummary.getTestGapRatio();
                ArrayList<Object> row = new ArrayList<Object>(Arrays.asList(issue.getIdAsString(), issue.getSubject(), issue.getStatus(), issue.getAssignee(), numberOfChanges, testGapRatio, tgaSummary.getNumberOfTestGaps()));
                1.writeCsvRow(builder, row);
            }
            return builder.toString();
        }

        private static void writeCsvRow(StringBuilder builder, List<Object> entries) {
            for (Object entry : entries) {
                String escapedValue = String.valueOf(entry).replace("\"", "\"\"");
                builder.append('\"').append(escapedValue).append('\"').append(';');
            }
            builder.append("\n");
        }
    }
    ,
    JSON(MediaType.APPLICATION_JSON_TYPE, "json"){

        @Override
        public List<Map<String, Object>> createPayload(List<TeamscaleIssueWithTgaInfo> issues, PublicProjectId projectId) {
            ArrayList<Map<String, Object>> issuesExport = new ArrayList<Map<String, Object>>();
            for (TeamscaleIssueWithTgaInfo issue : issues) {
                HashMap<String, Object> exportedIssue = new HashMap<String, Object>();
                exportedIssue.put("Issue ID", issue.getIdAsString());
                exportedIssue.put("Subject", issue.getSubject());
                exportedIssue.put("Status", issue.getStatus());
                exportedIssue.put("Assignee", issue.getAssignee());
                int numberOfChanges = issue.getTgaSummary().getTotalStates();
                double testGapRatio = numberOfChanges == 0 ? Double.NaN : issue.getTgaSummary().getTestGapRatio();
                exportedIssue.put("# Changes", numberOfChanges);
                exportedIssue.put("Test Gap", testGapRatio);
                exportedIssue.put("# Test Gaps", issue.getTgaSummary().getNumberOfTestGaps());
                issuesExport.add(exportedIssue);
            }
            return issuesExport;
        }
    };

    private final MediaType mediaType;
    private final String downloadExtension;

    private EIssuesExportFormat(MediaType mediaType, String downloadExtension) {
        this.mediaType = mediaType;
        this.downloadExtension = downloadExtension;
    }

    public abstract Object createPayload(List<TeamscaleIssueWithTgaInfo> var1, PublicProjectId var2);

    public Response createIssuesExportDownload(List<TeamscaleIssueWithTgaInfo> issues, PublicProjectId projectId) {
        Object entity = this.createPayload(issues, projectId);
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)this.mediaType, (String)("issues-" + String.valueOf(projectId) + "." + this.downloadExtension));
    }
}

