/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.assessment;

import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.merge_request.MetricAssessmentComputation;
import com.teamscale.index.metrics.assessment.GroupAssessment;
import com.teamscale.index.metrics.assessment.context.MetricDataRetrieverFactory;
import com.teamscale.index.metrics.threshold.MetricThresholdEvaluator;
import com.teamscale.index.thresholds.ProjectThresholdConfigurationUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.MetricAssessmentContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.issues.IssueContributor;
import com.teamscale.service.requirements_tracing.SpecItemContributor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/metric-assessments")
public class MetricAssessmentService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String THRESHOLD_CONFIGURATION_PARAMETER = "configuration-name";

    @GET
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, MetricAssessmentContributor.class, IssueContributor.class, SpecItemContributor.class})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get metric assessment", description="Provides a list of metrics and their assessment for a given path and threshold configuration", tags={"Metrics"})
    public List<GroupAssessment> getMetricAssessmentWithUniformPath(@Parameter(description="Uniform path of requested file or directory.", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commitString, @Parameter(description="ID of the metric threshold configuration.") @QueryParam(value="configuration-name") String thresholdConfig, @Parameter(description="The timestamp used as baseline for trends. If this parameter is missing, no trend is computed.") @QueryParam(value="baseline") UnresolvedCommitDescriptor baseline, @Parameter(description="When set, the delta between baseline and current timestamp is computed based on which external metric uploads are available in non-code partitions.") @QueryParam(value="use-partition-delta") @DefaultValue(value="false") boolean usePartitionDelta) throws StorageException, MetricThresholdConfigurationException {
        Optional<Object> optionalBaseline = baseline == null ? Optional.empty() : Optional.of(baseline);
        return this.computeAssessmentResultAndHandleFailures(uniformPath.toString(), this.determineHistoryOption(commitString), thresholdConfig, optionalBaseline, usePartitionDelta);
    }

    @GET
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, MetricAssessmentContributor.class, IssueContributor.class, SpecItemContributor.class})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_1_0, deprecatedSince=ETeamscaleVersion.VERSION_2024_9_0)
    @Operation(summary="Get metric assessment", description="Provides a list of metrics and their assessment for a given path and threshold configuration", tags={"Metrics"})
    public List<GroupAssessment> getOldMetricAssessmentWithUniformPath(@Parameter(description="Uniform path of requested file or directory.", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commitString, @Parameter(description="ID of the metric threshold configuration.") @QueryParam(value="configuration-name") String thresholdConfig, @Parameter(description="The timestamp used as baseline for trends. If this parameter is missing, no trend is computed.") @QueryParam(value="baseline") UnresolvedCommitDescriptor baseline, @Parameter(description="When set, the delta between baseline and current timestamp is computed based on which external metric uploads are available in non-code partitions.") @QueryParam(value="use-partition-delta") @DefaultValue(value="false") boolean usePartitionDelta) throws StorageException, MetricThresholdConfigurationException {
        return this.getMetricAssessmentWithUniformPath(uniformPath, commitString, thresholdConfig, baseline, usePartitionDelta);
    }

    private List<GroupAssessment> computeAssessmentResultAndHandleFailures(String uniformPath, HistoryAccessOption historyAccessOption, String thresholdConfig, Optional<UnresolvedCommitDescriptor> baseline, boolean usePartitionDelta) throws MetricThresholdConfigurationException, StorageException {
        return MetricAssessmentService.computeAssessmentResult(thresholdConfig, (IStorageInfo)this.serviceInfo, uniformPath, historyAccessOption, this.getUser(), baseline, usePartitionDelta, this.getParallelTaskExecutor());
    }

    public static List<GroupAssessment> computeAssessmentResult(String thresholdConfigurationName, IStorageInfo storageInfo, String uniformPath, HistoryAccessOption historyAccessOption, User currentUser, Optional<UnresolvedCommitDescriptor> baseline, boolean usePartitionDelta, IParallelTaskExecutor parallelTaskExecutor) throws StorageException, MetricThresholdConfigurationException {
        MetricAssessmentComputation assessmentComputation = MetricAssessmentService.buildMetricAssessmentComputer(thresholdConfigurationName, storageInfo, currentUser, parallelTaskExecutor);
        if (baseline.isPresent()) {
            return assessmentComputation.computeAssessment(uniformPath, historyAccessOption, MetricAssessmentService.retrieveBaselineHistoryAccessOption(baseline.get(), storageInfo.getProjectStorageSystem()), usePartitionDelta);
        }
        return assessmentComputation.computeAssessment(uniformPath, historyAccessOption, null, false);
    }

    private static MetricAssessmentComputation buildMetricAssessmentComputer(String thresholdConfigurationName, IStorageInfo storageInfo, User currentUser, IParallelTaskExecutor parallelTaskExecutor) throws StorageException {
        MetricSchemaRetrieverFactory schemaRetrieverFactory = new MetricSchemaRetrieverFactory(storageInfo.getProjectStorageSystem());
        MetricThresholdEvaluator configurationInterval = ProjectThresholdConfigurationUtils.getThresholdEvaluator((String)thresholdConfigurationName, (IStorageInfo)storageInfo, (MetricSchemaRetrieverFactory)schemaRetrieverFactory);
        MetricDataRetrieverFactory metricDataRetrieverFactory = new MetricDataRetrieverFactory(storageInfo.getProjectStorageSystem(), storageInfo.getGlobalStorageSystem(), currentUser, schemaRetrieverFactory);
        return new MetricAssessmentComputation(configurationInterval, metricDataRetrieverFactory, storageInfo.getProjectStorageSystem(), parallelTaskExecutor);
    }

    private static HistoryAccessOption retrieveBaselineHistoryAccessOption(UnresolvedCommitDescriptor unresolvedBaseline, ProjectStorageSystem storageSystem) {
        try {
            CommitDescriptor baseline = UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)unresolvedBaseline, () -> storageSystem);
            return HistoryAccessOption.readTimestamp((String)baseline.getBranchName(), (long)baseline.getTimestamp());
        }
        catch (StorageException e) {
            LOGGER.error("Error parsing baseline: " + String.valueOf(unresolvedBaseline), (Throwable)e);
            return null;
        }
    }
}

