/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.ApiBase;
import jakarta.ws.rs.BadRequestException;
import java.util.Collection;
import org.conqat.engine.core.optional.OptionalWithException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public abstract class RepositoryPreviewServiceBase
extends ApiBase {
    protected Collection<String> previewValues(ConnectorConfiguration connectorConfiguration, @Nullable PublicProjectId projectId) throws StorageException, RepositoryException, ServiceCallException {
        ExternalCredentials credentials = this.getCredentials(connectorConfiguration);
        boolean projectExists = projectId != null && this.openGlobalIndex(ProjectIndex.class).tryResolveProject((IProjectId)projectId).isPresent();
        this.checkPreviewPermissions(projectExists, projectId, credentials);
        try {
            return this.retrieveValuesFromRepository(projectExists, projectId, credentials, connectorConfiguration);
        }
        catch (ProjectConfigurationException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private @Nullable ExternalCredentials getCredentials(ConnectorConfiguration connectorConfiguration) throws StorageException {
        return (ExternalCredentials)OptionalWithException.ofNullable((Object)connectorConfiguration.getOptionValue("Account")).map(optionValue -> this.openGlobalIndex(ExternalCredentialsIndex.class).getExternalCredentials(optionValue)).orElse(null);
    }

    private void checkPreviewPermissions(boolean projectExists, PublicProjectId projectId, @Nullable ExternalCredentials credentials) throws StorageException {
        if (projectExists) {
            this.getPermissions().checkProjectPermission((IProjectId)projectId, EProjectPermission.EDIT);
        } else {
            this.getPermissions().checkGlobalPermission(EGlobalPermission.CREATE_PROJECTS);
        }
        if (credentials != null) {
            this.getPermissions().checkBasicPermission(EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, credentials.credentialsName, EBasicPermission.VIEW);
        }
    }

    protected abstract Collection<String> retrieveValuesFromRepository(boolean var1, PublicProjectId var2, @Nullable ExternalCredentials var3, ConnectorConfiguration var4) throws StorageException, RepositoryException, ProjectConfigurationException, ServiceCallException;
}

