/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.index.testimpact.ETestPrioritizationStrategy;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.testimpact.MinimizationProgressCallback;
import com.teamscale.service.testimpact.TestDataRetriever;
import com.teamscale.service.testimpact.TestPrioritizationData;
import com.teamscale.service.testimpact.prioritization.ITestPrioritizationStrategy;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import com.teamscale.service.testimpact.prioritization.PrioritizableTestBase;
import com.teamscale.service.testimpact.prioritization.PrioritizableTestCluster;
import com.teamscale.service.testimpact.prioritization.preprocessing.LoadAllCoveredMethodsStep;
import com.teamscale.service.testimpact.prioritization.preprocessing.LoadChangedAsCoveredMethodsStep;
import com.teamscale.service.testimpact.prioritization.preprocessing.LoadTestDurationStep;
import com.teamscale.service.testimpact.prioritization.preprocessing.PreprocessingStepManager;
import com.teamscale.service.testimpact.prioritization.strategies.AdditionalCoveragePerTimePrioritizationStrategy;
import com.teamscale.service.testimpact.prioritization.strategies.CheapAdditionalCoveragePerTimePrioritizationStrategy;
import com.teamscale.service.testimpact.prioritization.strategies.FullyRandomPrioritizationStrategy;
import com.teamscale.service.testimpact.prioritization.strategies.NoPrioritizationStrategy;
import com.teamscale.service.testimpact.prioritization.strategies.RandomButImpactedFirstPrioritizationStrategy;
import jakarta.ws.rs.InternalServerErrorException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.SetMap;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public abstract class TestReductionApiBase
extends ApiBase {
    protected static ITestPrioritizationStrategy initTestPrioritizationStrategy(TestDataRetriever dataRetriever, TestPrioritizationData testPrioritizationData, MinimizationProgressCallback callback, ETestPrioritizationStrategy testPrioritizationStrategy) throws StorageException {
        PreprocessingStepManager preprocessingStepManager = new PreprocessingStepManager();
        TestReductionApiBase.registerStepsToManager(preprocessingStepManager, dataRetriever);
        ITestPrioritizationStrategy prioritizationStrategy = TestReductionApiBase.createPrioritizationStrategy(testPrioritizationStrategy, callback);
        prioritizationStrategy.loadFurtherData(preprocessingStepManager, testPrioritizationData.getSelectedTests());
        return prioritizationStrategy;
    }

    private static void registerStepsToManager(PreprocessingStepManager preprocessingStepManager, TestDataRetriever dataRetriever) {
        preprocessingStepManager.registerStep(new LoadAllCoveredMethodsStep(dataRetriever));
        preprocessingStepManager.registerStep(new LoadChangedAsCoveredMethodsStep(dataRetriever));
        preprocessingStepManager.registerStep(new LoadTestDurationStep(dataRetriever));
    }

    protected static List<PrioritizableTestCluster> getTestClusters(SetMap<String, PrioritizableTest> clusteredTests, TestPrioritizationData testPrioritizationData, ITestPrioritizationStrategy prioritizationStrategy, MinimizationProgressCallback callback, @Nullable Long maxTimeBudgetMs) throws InterruptedException, StorageException {
        ArrayList<PrioritizableTestCluster> testClusters = new ArrayList<PrioritizableTestCluster>();
        try (MinimizationProgressCallback subProcessCallback = callback.processStarts("Selecting Test Clusters");){
            subProcessCallback.setProcessMaxSteps(clusteredTests.size());
            for (Map.Entry testEntry : clusteredTests) {
                List testsInCluster = ((Set)testEntry.getValue()).stream().toList();
                testsInCluster.forEach(PrioritizableTestBase::resetCurrentAdditionallyCoveredMethods);
                testClusters.add(PrioritizableTestCluster.create((String)((String)testEntry.getKey()), testsInCluster));
                subProcessCallback.reportProgress();
            }
        }
        Set<MethodId> methodsToTest = testPrioritizationData.getMethodsToTest();
        return prioritizationStrategy.orderMultipleTests(testClusters, methodsToTest, maxTimeBudgetMs, prioritizationStrategy.budgetPrioritizationCallback(methodsToTest));
    }

    @VisibleForTesting
    public static ITestPrioritizationStrategy createPrioritizationStrategy(ETestPrioritizationStrategy prioritizationStrategyType, MinimizationProgressCallback progressCallback) {
        try {
            Class strategy = switch (prioritizationStrategyType) {
                default -> throw new MatchException(null, null);
                case ETestPrioritizationStrategy.NONE -> NoPrioritizationStrategy.class;
                case ETestPrioritizationStrategy.FULLY_RANDOM -> FullyRandomPrioritizationStrategy.class;
                case ETestPrioritizationStrategy.RANDOM_BUT_IMPACTED_FIRST -> RandomButImpactedFirstPrioritizationStrategy.class;
                case ETestPrioritizationStrategy.ADDITIONAL_COVERAGE_PER_TIME -> AdditionalCoveragePerTimePrioritizationStrategy.class;
                case ETestPrioritizationStrategy.CHEAP_ADDITIONAL_COVERAGE_PER_TIME -> CheapAdditionalCoveragePerTimePrioritizationStrategy.class;
            };
            Constructor constructor = strategy.getDeclaredConstructor(MinimizationProgressCallback.class);
            return (ITestPrioritizationStrategy)constructor.newInstance(progressCallback);
        }
        catch (ReflectiveOperationException e) {
            throw new InternalServerErrorException("Test prioritization failed", (Throwable)e);
        }
    }
}

