/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions;

import com.google.common.collect.Sets;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryBase;
import com.teamscale.index.admin.instance_comparison.comparison.PredefinedImprovedInstanceComparisonDiffEntry;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IDetailedInstanceComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.KeyValueInstanceComparisonValueBase;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CounterSetInstanceComparisonValue<T>
extends KeyValueInstanceComparisonValueBase<CounterSet<T>> {
    private final Function<T, String> toStringFunction;

    public CounterSetInstanceComparisonValue(@NonNull String key, @NonNull CounterSet<T> value) {
        this(key, value, null, CounterSetInstanceComparisonValue.noImprovement());
    }

    public CounterSetInstanceComparisonValue(@NonNull String key, @NonNull CounterSet<T> value, @Nullable IDetailedInstanceComparisonContribution detail, Predicate<Pair<@Nullable CounterSet<T>, @Nullable CounterSet<T>>> onlyImprovementDecider) {
        this(key, value, detail, onlyImprovementDecider, String::valueOf);
    }

    public CounterSetInstanceComparisonValue(@NonNull String key, @NonNull CounterSet<T> value, @Nullable IDetailedInstanceComparisonContribution detail, Predicate<Pair<@Nullable CounterSet<T>, @Nullable CounterSet<T>>> onlyImprovementDecider, Function<T, String> toStringFunction) {
        super(key, value, detail, onlyImprovementDecider, null);
        this.toStringFunction = toStringFunction;
    }

    @Override
    protected Optional<? extends InstanceComparisonDiffEntryBase<?>> computeDifference(InstanceComparisonContributionBase.ComparisonContext context, @Nullable KeyValueInstanceComparisonValueBase<CounterSet<T>> local, @Nullable KeyValueInstanceComparisonValueBase<CounterSet<T>> remote) {
        CounterSet localValue = local != null ? (CounterSet)local.value : null;
        CounterSet remoteValue = remote != null ? (CounterSet)remote.value : null;
        Pair localAndRemoteValue = Pair.createPair((Object)localValue, (Object)remoteValue);
        if (localValue == null || remoteValue == null) {
            return Optional.of(PredefinedImprovedInstanceComparisonDiffEntry.fromObject(this.key, this.formatToString(localValue), this.formatToString(remoteValue), IInstanceComparisonValue.computeExamples(this.key, local, remote), this.onlyImprovementDecider.test(localAndRemoteValue), false));
        }
        if (Objects.equals(localValue, remoteValue)) {
            return Optional.empty();
        }
        double acceptedDeviation = context.getAcceptedComparisonDeviation(this.getAcceptedDeviationKey());
        boolean withinAcceptedDeviation = true;
        for (Object key : Sets.union((Set)localValue.getKeys(), (Set)remoteValue.getKeys())) {
            int localCount = localValue.getValue(key);
            int remoteCount = remoteValue.getValue(key);
            withinAcceptedDeviation &= IInstanceComparisonValue.isWithinAcceptedDeviation(localCount, remoteCount, acceptedDeviation);
        }
        return Optional.of(PredefinedImprovedInstanceComparisonDiffEntry.fromObject(this.key, this.formatToString(localValue), this.formatToString(remoteValue), IInstanceComparisonValue.computeExamples(this.key, local, remote), this.onlyImprovementDecider.test(localAndRemoteValue), withinAcceptedDeviation));
    }

    private @Nullable String formatToString(@Nullable CounterSet<T> set) {
        if (set == null) {
            return null;
        }
        return set.toSortedMap().entrySet().stream().map(entry -> "%s: %d".formatted(this.toStringFunction.apply(entry.getKey()), entry.getValue())).collect(Collectors.joining(", "));
    }
}

