/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis.classification;

import com.teamscale.index.comment_analysis.classification.IMethodFinder;
import com.teamscale.index.comment_analysis.utils.MemberExtractor;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import org.conqat.lib.commons.collections.Pair;

public class MethodFinder
implements IMethodFinder {
    private final List<IToken> tokenList;
    private final MemberExtractor memberExtractor;

    public MethodFinder(List<ShallowEntity> entities, List<IToken> tokenList) {
        this.tokenList = tokenList;
        this.memberExtractor = new MemberExtractor(entities);
    }

    private Pair<String, Integer> getNameAndDistanceToNextMember(int tokenListIndex, int lineNumber, boolean stopAtComments, boolean stopAtIdentifier) {
        int i;
        for (i = tokenListIndex - 1; i >= 0; --i) {
            IToken token = this.tokenList.get(i);
            if (token.getLineNumber() == lineNumber && this.memberExtractor.containsMemberIdentifier(token.getText(), this.tokenList.get(i).getOffset())) {
                return new Pair((Object)token.getText(), (Object)0);
            }
            if (token.getLineNumber() < lineNumber) break;
        }
        for (i = tokenListIndex + 1; i < this.tokenList.size(); ++i) {
            if (stopAtComments && this.tokenList.get(i).getType().getTokenClass() == ETokenType.ETokenClass.COMMENT) {
                return new Pair((Object)"", (Object)-1);
            }
            if (this.memberExtractor.containsMemberIdentifier(this.tokenList.get(i).getText(), this.tokenList.get(i).getOffset())) {
                return new Pair((Object)this.tokenList.get(i).getText(), (Object)(i - tokenListIndex));
            }
            if (!stopAtIdentifier || this.tokenList.get(i).getType().getTokenClass() != ETokenType.ETokenClass.IDENTIFIER || this.isJavaAnnotation(i)) continue;
            return new Pair((Object)"", (Object)-1);
        }
        return new Pair((Object)"", (Object)-1);
    }

    private boolean isJavaAnnotation(int i) {
        if (i > 0 && this.tokenList.get(i).getLanguage() == ELanguage.JAVA) {
            return this.tokenList.get(i - 1).getType() == ETokenType.AT_OPERATOR;
        }
        return false;
    }

    @Override
    public IToken getNextDefinitionType(int tokenListIndex) {
        return this.getNextDefinitionType(tokenListIndex, true);
    }

    @Override
    public IToken getNextDefinitionType(int tokenListIndex, boolean stopAtComments) {
        int nextDefinitionDistance = this.getDistanceToNextDefinition(tokenListIndex, stopAtComments, false);
        return this.tokenList.get(tokenListIndex + nextDefinitionDistance - 1);
    }

    @Override
    public boolean isMethodDefinition(int tokenListIndex) {
        return this.isMethodDefinition(tokenListIndex, true, false);
    }

    @Override
    public boolean isMethodDefinition(int tokenListIndex, boolean stopAtComments, boolean stopAtIdentifier) {
        int nextDefinitionDistance = this.getDistanceToNextDefinition(tokenListIndex, stopAtComments, stopAtIdentifier);
        if (nextDefinitionDistance == -1) {
            return false;
        }
        int index = tokenListIndex + nextDefinitionDistance + 1;
        if (index <= this.tokenList.size() - 1) {
            IToken nextToken = this.tokenList.get(index);
            return nextToken.getType() == ETokenType.LPAREN;
        }
        return false;
    }

    @Override
    public String getNextDefinition(int tokenListIndex) {
        return this.getNextDefinition(tokenListIndex, true);
    }

    @Override
    public String getNextDefinition(int tokenListIndex, boolean stopAtComments) {
        return (String)this.getNameAndDistanceToNextMember(tokenListIndex, this.tokenList.get(tokenListIndex).getLineNumber(), stopAtComments, false).getFirst();
    }

    @Override
    public int getDistanceToNextDefinition(int tokenListIndex) {
        return this.getDistanceToNextDefinition(tokenListIndex, true, false);
    }

    @Override
    public int getDistanceToNextDefinition(int tokenListIndex, boolean stopAtComments, boolean stopAtIdentifier) {
        return (Integer)this.getNameAndDistanceToNextMember(tokenListIndex, this.tokenList.get(tokenListIndex).getLineNumber(), stopAtComments, stopAtIdentifier).getSecond();
    }
}

