/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.iec;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.VariableWriteDependencyIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.STFileType;
import com.teamscale.index.resource.element_details.VariableDeclarationDetail;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class StructuredTextDependencyExtractor
extends DependencyExtractorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final TokenPattern COLON_TYPE_DEF_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.IDENTIFIER}).group(0);
    private static final TokenPattern ARRAY_DEC_ELEMENT_TYPE_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.RBRACK, ETokenType.OF, ETokenType.IDENTIFIER}).group(0);
    private static final TokenPattern REFERENCE_TYPE_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.REF_TO, ETokenType.IDENTIFIER}).group(0);

    public static void unregisterVariableWrites(TokenElementInfo element, VariableWriteDependencyIndex stVariableWriteIndex) throws StorageException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType(element.getShallowEntitiesWithPreprocessorTokens(), (EShallowEntityType)EShallowEntityType.METHOD);
        stVariableWriteIndex.removeVariableWritesForTypes(CollectionUtils.map((Collection)types, ShallowEntity::getName));
    }

    public static void registerVariableWrites(TokenElementInfo element, VariableWriteDependencyIndex variableDependencyIndex) throws StorageException {
        Optional variableDetail = element.getFirstDetailOfType(VariableDeclarationDetail.class);
        if (!variableDetail.isPresent()) {
            STFileType fileType = element.getFirstDetailOfType(STFileType.class).orElse(null);
            if (!STFileType.TYPES.equals((Object)fileType)) {
                LOGGER.error("Cannot register variable writes for " + element.getUniformPath() + ", because there is no variable declaration metadata.");
            }
            return;
        }
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType(element.getShallowEntitiesWithPreprocessorTokens(), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            String currentType = method.getName();
            List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)method.getChildren(), (EShallowEntityType)EShallowEntityType.STATEMENT);
            for (ShallowEntity statement : statements) {
                StructuredTextDependencyExtractor.registerVariableWrites(statement, currentType, ((VariableDeclarationDetail)((Object)variableDetail.get())).getExternalVariables(), variableDependencyIndex);
            }
        }
    }

    private static void registerVariableWrites(ShallowEntity statement, String type, Set<String> externalVariables, VariableWriteDependencyIndex variableDependencyIndex) throws StorageException {
        boolean assignmentSeen = false;
        for (IToken token : statement.includedTokens()) {
            if (token.getType().isIdentifier() && externalVariables.contains(token.getText())) {
                if (!StructuredTextDependencyExtractor.isAssignment(statement) || assignmentSeen) continue;
                String variable = token.getText();
                variableDependencyIndex.addVariableWrites(variable, Collections.singleton(type));
                continue;
            }
            if (token.getType() != ETokenType.ASSIGNMENT) continue;
            assignmentSeen = true;
        }
    }

    @Override
    protected List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo) throws StorageException {
        Optional<VariableDeclarationDetail> variableDetail = tokenElementInfo.getFirstDetailOfType(VariableDeclarationDetail.class);
        if (!variableDetail.isPresent()) {
            LOGGER.error("Cannot extract dependencies for " + this.uniformPath + ", because there is no variable declaration metadata.");
            variableDetail = Optional.of(new VariableDeclarationDetail());
        }
        return this.extractDependencies(tokenElementInfo, this.settings.includeThirdPartyDependencies, (VariableDeclarationDetail)((Object)variableDetail.get()));
    }

    private List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo, boolean includeThirdPartyDependencies, VariableDeclarationDetail variableDeclarationDetails) throws StorageException {
        ArrayList<TypeDependencies> dependencies = new ArrayList<TypeDependencies>();
        HashMap<String, String> localVariableTypes = new HashMap<String, String>();
        for (String variable : variableDeclarationDetails.getLocalVariables()) {
            localVariableTypes.put(variable.toLowerCase(), variableDeclarationDetails.getTypeOfLocalVariable(variable));
        }
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType(tokenElementInfo.getShallowEntitiesWithPreprocessorTokens(), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            dependencies.add(this.extractDependenciesFromMethod(method, variableDeclarationDetails, localVariableTypes, includeThirdPartyDependencies));
        }
        dependencies.addAll(this.extractDependenciesFromTypeDefs(tokenElementInfo, includeThirdPartyDependencies));
        return dependencies;
    }

    private List<TypeDependencies> extractDependenciesFromTypeDefs(TokenElementInfo element, boolean includeThirdPartyDependencies) {
        List typedefs = ShallowEntityTraversalUtils.listEntitiesOfType(element.getShallowEntitiesWithPreprocessorTokens(), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        typedefs = CollectionUtils.filter((Collection)typedefs, entity -> "typedef".equals(entity.getSubtype()));
        ArrayList<TypeDependencies> dependencies = new ArrayList<TypeDependencies>();
        for (ShallowEntity typedef : typedefs) {
            String currentTypeName = typedef.getName();
            ListMap<String, ElementLocation> targets = this.extractTypeReferenceTargets((UnmodifiableList<IToken>)typedef.includedTokens(), this.uniformPath, includeThirdPartyDependencies);
            if (targets.getKeys().isEmpty()) continue;
            dependencies.add(new TypeDependencies(currentTypeName, targets));
        }
        return dependencies;
    }

    private TypeDependencies extractDependenciesFromMethod(ShallowEntity method, VariableDeclarationDetail variableDeclarationDetails, Map<String, String> localVariableTypes, boolean includeThirdPartyDependencies) throws StorageException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)method.getChildren(), (EShallowEntityType)EShallowEntityType.STATEMENT);
        ListMap targets = new ListMap();
        for (ShallowEntity statement : statements) {
            this.extractDependenciesFromStatement(statement, variableDeclarationDetails, localVariableTypes, includeThirdPartyDependencies, method, (ListMap<String, ElementLocation>)targets);
        }
        targets.addAll(this.extractTypeReferenceTargets((UnmodifiableList<IToken>)method.includedTokens(), this.uniformPath, includeThirdPartyDependencies));
        return new TypeDependencies(method.getName(), (ListMap<String, ElementLocation>)targets);
    }

    private ListMap<String, ElementLocation> extractTypeReferenceTargets(UnmodifiableList<IToken> tokens, String uniformPath, boolean includeThirdPartyDependencies) {
        ArrayList<IToken> typeTokens = new ArrayList<IToken>();
        for (TokenPatternMatch match : COLON_TYPE_DEF_PATTERN.findAll(tokens)) {
            typeTokens.add((IToken)match.groupTokens(0).get(2));
        }
        for (TokenPatternMatch match : ARRAY_DEC_ELEMENT_TYPE_PATTERN.findAll(tokens)) {
            typeTokens.add((IToken)match.groupTokens(0).get(2));
        }
        for (TokenPatternMatch match : REFERENCE_TYPE_PATTERN.findAll(tokens)) {
            typeTokens.add((IToken)match.groupTokens(0).get(3));
        }
        ListMap targets = new ListMap();
        for (IToken typeToken : typeTokens) {
            String typeName = typeToken.getText();
            if (!this.typeLookupEnvironment.isKnownType(typeName) && !includeThirdPartyDependencies) continue;
            targets.add((Object)typeName, (Object)StructuredTextDependencyExtractor.createLocation(uniformPath, typeToken));
        }
        return targets;
    }

    private void extractDependenciesFromStatement(ShallowEntity statement, VariableDeclarationDetail variableDeclarationDetails, Map<String, String> localVariableTypes, boolean includeThirdPartyDependencies, ShallowEntity type, ListMap<String, ElementLocation> targets) throws StorageException {
        IToken previousToken = null;
        boolean assignmentSeen = false;
        for (IToken token : statement.includedTokens()) {
            if (token.getType().isIdentifier() && variableDeclarationDetails.getExternalVariables().contains(token.getText())) {
                if (assignmentSeen || !StructuredTextDependencyExtractor.isAssignment(statement)) {
                    this.handleGlobalVariableRead(token, type, targets);
                }
            } else if (token.getType() == ETokenType.ASSIGNMENT) {
                assignmentSeen = true;
            } else if (token.getType() == ETokenType.LPAREN && previousToken != null && previousToken.getType().isIdentifier()) {
                this.handleControlDependency(previousToken, localVariableTypes, includeThirdPartyDependencies, targets);
            }
            previousToken = token;
        }
    }

    private void handleGlobalVariableRead(IToken variable, ShallowEntity type, ListMap<String, ElementLocation> targets) throws StorageException {
        TreeSet<String> writingTypes = this.dependencyExtractionIndexes.variableWriteIndex.getVariableWrites(variable.getText());
        if (writingTypes == null) {
            return;
        }
        for (String writingType : writingTypes) {
            if (type.getName().equalsIgnoreCase(writingType)) continue;
            targets.add((Object)writingType, (Object)StructuredTextDependencyExtractor.createLocation(this.uniformPath, variable));
        }
    }

    private void handleControlDependency(IToken call, Map<String, String> localVariableTypes, boolean includeThirdPartyDependencies, ListMap<String, ElementLocation> targets) {
        String target = call.getText();
        String targetType = localVariableTypes.get(target.toLowerCase());
        if (targetType != null) {
            target = targetType;
        }
        if (this.typeLookupEnvironment.isKnownType(target) || includeThirdPartyDependencies) {
            targets.add((Object)target, (Object)StructuredTextDependencyExtractor.createLocation(this.uniformPath, call));
        }
    }

    private static boolean isAssignment(ShallowEntity statement) {
        if (!"simple statement".equals(statement.getSubtype())) {
            return false;
        }
        for (IToken token : statement.includedTokens()) {
            if (token.getType() != ETokenType.ASSIGNMENT) continue;
            return true;
        }
        return false;
    }
}

