/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.metrics;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.metrics.source.IndexMetricSource;
import com.teamscale.index.project.ExternalCodeMetricsDescriptionIndex;
import com.teamscale.index.project.MetricSchemaChangeEntry;
import com.teamscale.index.resource.ContentIndexInputAnalysisStepBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ExternalMetricsSynchronizer
extends ContentIndexInputAnalysisStepBase {
    @IndexAccess(indexName="metrics", value=EIndexAccessMode.READ_WRITE)
    private MetricsIndex metricsIndex;
    @IndexAccess(indexName="metric-schema", value=EIndexAccessMode.READ_ONLY)
    private MetricSchemaIndex metricSchemaIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalCodeMetricsDescriptionIndex externalMetricsIndex;

    public void execute() throws StorageException {
        HashSet globallyAvailableExternalMetricIds = new HashSet(CollectionUtils.map(this.externalMetricsIndex.getAllMetrics(), MetricSchemaChangeEntry::getMetricId));
        MetricDirectorySchema schema = this.metricSchemaIndex.getSchema(false);
        UnmodifiableList entries = schema.getAllEntries();
        List sources = this.metricSchemaIndex.getMetricSources();
        List indexMetricSources = CollectionUtils.filterAndMap((Collection)sources, source -> source instanceof IndexMetricSource, source -> (IndexMetricSource)source);
        Map<String, Serializable> partitionToDefaultMapping = indexMetricSources.stream().filter(source -> globallyAvailableExternalMetricIds.contains(source.getMetricPartition())).collect(Collectors.toMap(source -> source.getMetricPartition(), source -> (Serializable)((MetricDirectorySchemaEntry)entries.get(sources.indexOf(source))).getValueType().getDefaultValue()));
        this.metricsIndex.removeEntries((Collection)this.contentDelta.getDeletedKeysAsStrings(), partitionToDefaultMapping.keySet());
        List changedFiles = this.contentDelta.getAddedOrChangedKeysAsStrings();
        PairList partitionAndPaths = MetricsIndex.buildPartitionAndPathList(new ArrayList<String>(partitionToDefaultMapping.keySet()), (List)changedFiles);
        this.updateMetrics(partitionToDefaultMapping, (PairList<String, String>)partitionAndPaths);
    }

    private void updateMetrics(Map<String, Serializable> partitionToDefaultMapping, PairList<String, String> partitionAndPaths) throws StorageException {
        List values = this.metricsIndex.getMetricValues(partitionAndPaths);
        HashMap<String, PairList> correctedValues = new HashMap<String, PairList>();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (value != null) continue;
            String partitionName = (String)partitionAndPaths.getFirst(i);
            PairList newValues = correctedValues.computeIfAbsent(partitionName, x -> new PairList());
            newValues.add((Object)((String)partitionAndPaths.getSecond(i)), (Object)partitionToDefaultMapping.get(partitionName));
        }
        for (String partition : correctedValues.keySet()) {
            this.metricsIndex.setMetricValues((PairList)correctedValues.get(partition), partition);
        }
    }
}

