/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.update;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.index.external.ExternalAnalysisCommitInfo;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.ExternalUploadIndexBase;
import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStepInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusInfo;
import com.teamscale.index.external.update.ExternalUploadChangeRetrieverBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AnalysisStep(hints={EAnalysisStepParameter.COMMITS_NEED_PARENT_ADJUSTMENT_FOR_PREVIOUSLY_FORKED_COMMITS})
public class ExternalAnalysisResultsChangeRetriever
extends ExternalUploadChangeRetrieverBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String COMMIT_TREE_INDEX_NAME = "external-analysis-commit-tree";
    @BranchingLayerAccess(value=ExternalAnalysisResultIndex.class)
    private IBranchingLayer externalAnalysisResultBranchingLayer;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="external-analysis-commit-tree")
    private CommitTreeIndex commitTreeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExternalAnalysisStatusIndex statusIndex;

    @Override
    protected CommitTreeIndex getCommitTreeIndex() {
        return this.commitTreeIndex;
    }

    @Override
    protected IBranchingLayer getUploadBranchingLayer() {
        return this.externalAnalysisResultBranchingLayer;
    }

    @Override
    protected String getRepositoryIdentifier() {
        return "external analysis";
    }

    @Override
    protected void processCommitsAfterNodesWereAdded(List<ParentedCommitDescriptor> commitsThatNodesWereAddedFor) throws StorageException {
        super.processCommitsAfterNodesWereAdded(commitsThatNodesWereAddedFor);
        this.markUploadsAs(EExternalAnalysisProcessingStatus.QUEUED, commitsThatNodesWereAddedFor, Collections.emptyList());
    }

    private void markUploadsAs(EExternalAnalysisProcessingStatus processingStatus, List<? extends CommitDescriptor> commits, List<String> statusMessages) throws StorageException {
        this.statusIndex.runWithLock(statusIndexAccess -> {
            @Nullable PairList oldAndNewStatuses = new PairList();
            List<@Nullable ExternalAnalysisStatusInfo> oldStatuses = statusIndexAccess.getStatus(commits);
            this.addNewStatusesWithoutExistingOldStatuses(commits, oldStatuses, (PairList<ExternalAnalysisStatusInfo, ExternalAnalysisStatusInfo>)oldAndNewStatuses);
            ExternalAnalysisResultsChangeRetriever.copyExistingOldStatusesToNewStatuses(oldStatuses, (PairList<ExternalAnalysisStatusInfo, ExternalAnalysisStatusInfo>)oldAndNewStatuses);
            oldAndNewStatuses.getSecondList().forEach(externalAnalysisStatusInfo -> ExternalAnalysisResultsChangeRetriever.updateNewStatus(processingStatus, statusMessages, externalAnalysisStatusInfo));
            statusIndexAccess.updateStatuses((PairList<ExternalAnalysisStatusInfo, ExternalAnalysisStatusInfo>)oldAndNewStatuses);
        });
    }

    private static void updateNewStatus(EExternalAnalysisProcessingStatus processingStatus, List<String> statusMessages, ExternalAnalysisStatusInfo statusInfo) {
        UnmodifiableList<ExternalAnalysisProcessingStepInfo> oldProcessingSteps = statusInfo.getProcessingSteps();
        ExternalAnalysisProcessingStepInfo mostRecentStep = (ExternalAnalysisProcessingStepInfo)CollectionUtils.getLast(oldProcessingSteps);
        if (mostRecentStep != null && statusMessages.equals(mostRecentStep.getMessages()) && processingStatus == mostRecentStep.getStatus()) {
            statusInfo.replaceMostRecentStep(mostRecentStep.copyWithUpdatedTimestamp());
            return;
        }
        ExternalAnalysisProcessingStepInfo newStepInfo = new ExternalAnalysisProcessingStepInfo(processingStatus, true);
        newStepInfo.addMessages(statusMessages);
        statusInfo.addProcessingStep(newStepInfo);
    }

    private void addNewStatusesWithoutExistingOldStatuses(List<? extends CommitDescriptor> commits, List<@Nullable ExternalAnalysisStatusInfo> oldStatuses, PairList<@Nullable ExternalAnalysisStatusInfo, ExternalAnalysisStatusInfo> oldAndNewStatuses) throws StorageException {
        List<ExternalAnalysisStatusInfo> newStatusWithoutOldStates = this.markUploadsWithoutOldState(ExternalAnalysisResultsChangeRetriever.getCommitsWithoutExistingStatus(commits, oldStatuses));
        newStatusWithoutOldStates.forEach(newStatus -> oldAndNewStatuses.add(null, newStatus));
    }

    private static void copyExistingOldStatusesToNewStatuses(List<@Nullable ExternalAnalysisStatusInfo> oldStatuses, PairList<@Nullable ExternalAnalysisStatusInfo, ExternalAnalysisStatusInfo> oldAndNewStatuses) {
        for (ExternalAnalysisStatusInfo existingOldStatus : CollectionUtils.filter(oldStatuses, Objects::nonNull)) {
            ExternalAnalysisStatusInfo newStatus = ExternalAnalysisStatusInfo.copy(existingOldStatus, () -> (ExternalAnalysisStatusInfo)CCSMAssert.fail((String)"Should not happen"));
            oldAndNewStatuses.add((Object)existingOldStatus, (Object)newStatus);
        }
    }

    private static @NonNull List<CommitDescriptor> getCommitsWithoutExistingStatus(List<? extends CommitDescriptor> commits, List<@Nullable ExternalAnalysisStatusInfo> oldStatuses) {
        ArrayList<CommitDescriptor> commitsWithoutExistingStatus = new ArrayList<CommitDescriptor>();
        for (int i = 0; i < oldStatuses.size(); ++i) {
            if (oldStatuses.get(i) != null) continue;
            commitsWithoutExistingStatus.add(commits.get(i));
        }
        return commitsWithoutExistingStatus;
    }

    private List<ExternalAnalysisStatusInfo> markUploadsWithoutOldState(List<CommitDescriptor> commits) throws StorageException {
        ArrayList<ExternalAnalysisStatusInfo> newStatues = new ArrayList<ExternalAnalysisStatusInfo>();
        List commitInfos = ExternalUploadIndexBase.loadCommitInfos((CommitLayeringBranchingLayer)this.externalAnalysisResultBranchingLayer, commits);
        for (int i = 0; i < commits.size(); ++i) {
            ExternalAnalysisStatusInfo newStatus;
            CommitDescriptor commit = commits.get(i);
            ExternalAnalysisCommitInfo commitInfo = (ExternalAnalysisCommitInfo)((Object)commitInfos.get(i));
            if (commitInfo == null) {
                newStatus = new ExternalAnalysisStatusInfo(commit, true, 0L, false);
            } else {
                newStatus = new ExternalAnalysisStatusInfo(commit, true, commitInfo.getUploadTimestamp(), false);
                newStatus.addPartition(commitInfo.getPartition());
            }
            newStatues.add(newStatus);
        }
        return newStatues;
    }

    @Override
    protected void reportSkippedNode(CommitTreeNode node) {
        ParentedCommitDescriptor commit = new ParentedCommitDescriptor(node.getBranchName(), node.getOriginalTimestamp(), new CommitDescriptor[0]);
        try {
            this.markUploadsAs(EExternalAnalysisProcessingStatus.SKIPPED, List.of(commit), Collections.singletonList("Upload was skipped as it dates before the first code commit."));
        }
        catch (StorageException e) {
            LOGGER.error((Object)e);
        }
    }
}

