/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.kubescore;

import com.teamscale.index.findings.kubescore.KubernetesUtils;
import com.teamscale.index.findings.kubescore.entitites.KubernetesEntity;
import com.teamscale.index.findings.kubescore.entitites.KubernetesEntityMetadata;
import java.util.Map;
import java.util.regex.Pattern;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class KubernetesManifestHandler {
    private static final Pattern MANIFEST_SEPARATOR_REGEX = Pattern.compile("\n---( )*\n");
    private String[] originListPerLine;
    private PairList<String, LineBasedRegion> entitiesWithRegions;

    public KubernetesManifestHandler(String manifestContent, String uniformPath) {
        this.initialize(manifestContent, uniformPath);
    }

    public @Nullable String getOriginReferenceForLine(int line) {
        return this.originListPerLine[line - 1];
    }

    public PairList<String, LineBasedRegion> getEntitiesWithRegions() {
        return this.entitiesWithRegions;
    }

    private void initialize(String manifestContent, String uniformPath) {
        this.entitiesWithRegions = KubernetesManifestHandler.splitYamlIntoEntitiesWithRegions(manifestContent);
        this.originListPerLine = this.computeOriginListPerLine(manifestContent, uniformPath);
    }

    private static PairList<String, LineBasedRegion> splitYamlIntoEntitiesWithRegions(String manifestContent) {
        PairList entitiesWithLineOffsets = new PairList();
        int nextLineOffset = 1;
        if (manifestContent.startsWith("---\n")) {
            manifestContent = StringUtils.stripPrefix((String)manifestContent, (String)"---\n");
            ++nextLineOffset;
        }
        for (String entity : MANIFEST_SEPARATOR_REGEX.split(manifestContent)) {
            int currentLineOffset = nextLineOffset;
            int entityLineCount = StringUtils.countLines((String)entity, (boolean)true);
            int endLine = currentLineOffset + entityLineCount;
            entitiesWithLineOffsets.add((Object)entity, (Object)new LineBasedRegion(currentLineOffset, endLine));
            nextLineOffset += entityLineCount + 1;
        }
        return entitiesWithLineOffsets;
    }

    private static @Nullable String getOriginReferencePath(String entity, KubernetesEntity kubernetesEntity, String uniformPath) {
        if (entity.startsWith("# Source:")) {
            return KubernetesManifestHandler.getOriginReferenceForHelm(entity, uniformPath);
        }
        KubernetesEntityMetadata metadata = kubernetesEntity.getMetadata();
        if (metadata == null) {
            return null;
        }
        Map<String, Object> annotations = metadata.getAnnotations();
        if (annotations == null) {
            return null;
        }
        Object originObject = KubernetesUtils.convertToMap(annotations).get("config.kubernetes.io/origin");
        if (originObject instanceof String) {
            String originString = (String)originObject;
            if (originString.startsWith("path: ")) {
                String originReference = StringUtils.stripPrefix((String)originString, (String)"path: ").trim();
                return UniformPathUtils.resolveRelativePath((String)uniformPath, (String)originReference);
            }
            if (!originString.startsWith("configuredIn: ")) {
                CCSMAssert.fail((String)("Could not extract origin reference from entity: " + entity));
                return null;
            }
            String originReference = StringUtils.splitLines((String)StringUtils.stripPrefix((String)originString, (String)"configuredIn: "))[0].trim();
            return UniformPathUtils.resolveRelativePath((String)uniformPath, (String)originReference);
        }
        return null;
    }

    private static @NonNull String getOriginReferenceForHelm(String entity, String uniformPath) {
        String originReference = StringUtils.splitLines((String)StringUtils.stripPrefix((String)entity, (String)"# Source:"))[0].trim();
        String originReferenceWithoutChartName = originReference.substring(originReference.indexOf(47) + 1);
        return UniformPathUtils.resolveRelativePath((String)uniformPath, (String)originReferenceWithoutChartName);
    }

    private String[] computeOriginListPerLine(String manifestContent, String uniformPath) {
        int manifestLineCount = StringUtils.countLines((String)manifestContent, (boolean)true);
        String[] originListPerLine = new String[manifestLineCount];
        for (Pair entityWithLineOffset : this.entitiesWithRegions) {
            String entity = (String)entityWithLineOffset.getFirst();
            KubernetesEntity kubernetesEntity = KubernetesUtils.readEntityContent(uniformPath, entity);
            if (kubernetesEntity == null) continue;
            String originReferencePath = KubernetesManifestHandler.getOriginReferencePath(entity, kubernetesEntity, uniformPath);
            int startLine = ((LineBasedRegion)entityWithLineOffset.getSecond()).getStart() - 1;
            int endLine = ((LineBasedRegion)entityWithLineOffset.getSecond()).getEnd() - 1;
            for (int i = startLine; i < endLine; ++i) {
                originListPerLine[i] = originReferencePath;
            }
        }
        return originListPerLine;
    }
}

