/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.phpstan;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.configuration.tools.AnalysisToolsConfigurationUtils;
import com.teamscale.index.configuration.tools.PHPStanConfiguration;
import com.teamscale.index.findings.phpstan.PHPStanReport;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ProcessUtils;

class PHPStanExecutor {
    static final String PHP_EXECUTABLE = "php";
    private static final Duration TIMEOUT = (Duration)TeamscaleSystemProperties.PHPSTAN_TIMEOUT.getValue();
    private final Path phpStan = PHPStanConfiguration.getPhpStanArchive().toAbsolutePath();

    public PHPStanReport execute(Path workingDirectory, List<Path> analyzedFiles, List<Path> scanDirectories, Path tmpDirectory, int level, List<String> ignoreErrors, Map<String, Boolean> additionalConfigItems) throws ConQATException {
        Path configFile = PHPStanExecutor.buildConfigFile(analyzedFiles, scanDirectories, tmpDirectory, level, ignoreErrors, additionalConfigItems);
        ProcessUtils.ExecutionResult result = this.executePhpStan(workingDirectory, configFile);
        if (!result.getStderr().isEmpty()) {
            throw new ConQATException("PHPStan execution error: %s".formatted(result));
        }
        return PHPStanReport.fromJson(result.getStdout());
    }

    private ProcessUtils.ExecutionResult executePhpStan(Path workingDirectory, Path configFile) throws ConQATException {
        ProcessUtils.ExecutionResult result;
        ProcessBuilder processBuilder = new ProcessBuilder(PHP_EXECUTABLE, this.phpStan.toString(), "analyse", "--no-ansi", "--no-progress", "--memory-limit", "1G", "-c", configFile.toAbsolutePath().toString());
        processBuilder.directory(workingDirectory.toFile());
        AnalysisToolsConfigurationUtils.preventUsageOfJemalloc(processBuilder);
        try {
            result = ProcessUtils.execute((ProcessBuilder)processBuilder, null, (Duration)TIMEOUT);
        }
        catch (IOException e) {
            throw new ConQATException("Failed to execute PHPStan", (Throwable)e);
        }
        if (result.terminatedByTimeoutOrInterruption() || PHPStanExecutor.isNotSuccessful(result)) {
            throw new ConQATException(result.toString());
        }
        return result;
    }

    private static boolean isNotSuccessful(ProcessUtils.ExecutionResult result) {
        return result.getReturnCode() != 0 && result.getReturnCode() != 1;
    }

    private static Path buildConfigFile(List<Path> analyzedFiles, List<Path> scanDirectories, Path tmpDirectory, int level, List<String> ignoreErrors, Map<String, Boolean> additionalConfigItems) throws ConQATException {
        String configTemplate = PHPStanExecutor.buildConfigTemplate(level, analyzedFiles, scanDirectories, tmpDirectory, ignoreErrors, additionalConfigItems);
        Path configFile = tmpDirectory.resolve("ts_config.neon");
        try {
            FileSystemUtils.writeFileUTF8((Path)configFile, (String)configTemplate);
        }
        catch (IOException e) {
            throw new ConQATException("Unable to write configuration file", (Throwable)e);
        }
        return configFile;
    }

    private static String buildConfigTemplate(int level, List<Path> analyzedFiles, List<Path> scanDirectories, Path tmpDirectory, List<String> ignoreErrors, Map<String, Boolean> additionalConfigItems) {
        PHPStanConfig config = new PHPStanConfig(new PHPStanConfig.PHPStanConfigParameters(level, (UnmodifiableList<Path>)CollectionUtils.asUnmodifiable(analyzedFiles.stream().map(Path::toAbsolutePath).toList()), (UnmodifiableList<Path>)CollectionUtils.asUnmodifiable(scanDirectories.stream().map(Path::toAbsolutePath).toList()), tmpDirectory.toAbsolutePath(), false, "json", (UnmodifiableList<String>)CollectionUtils.asUnmodifiable(ignoreErrors), (UnmodifiableMap<String, Boolean>)CollectionUtils.asUnmodifiable(additionalConfigItems)));
        return JsonUtils.serializeToJSON((Object)config);
    }

    private record PHPStanConfig(@JsonProperty(value="parameters") PHPStanConfigParameters parameters) {

        record PHPStanConfigParameters(int level, @JsonProperty(value="paths") UnmodifiableList<Path> paths, @JsonProperty(value="scanDirectories") UnmodifiableList<Path> scanDirectories, @JsonProperty(value="tmpDir") Path tmpDir, @JsonProperty(value="tipsOfTheDay") boolean tipsOfTheDay, @JsonProperty(value="errorFormat") String errorFormat, @JsonProperty(value="ignoreErrors") UnmodifiableList<String> ignoreErrors, @JsonAnyGetter UnmodifiableMap<String, Boolean> additionalConfigItems) {
            @JsonGetter(value="level")
            private JsonNode levelJsonValue() {
                if (this.level < 0) {
                    return JsonNodeFactory.instance.textNode("max");
                }
                return JsonNodeFactory.instance.numberNode(this.level);
            }
        }
    }
}

