/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.voting;

import com.google.common.annotations.VisibleForTesting;
import com.teamscale.core.analysis.configuration.model.option.EJiraIssueUpdateCategory;
import com.teamscale.core.analysis.configuration.model.option.JiraIssueUpdateTgaBranchConfiguration;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.findings.calculation.FindingsServiceUtils;
import com.teamscale.index.issues.jira.voting.ExtendedJiraIssueUpdateConfiguration;
import com.teamscale.index.issues.jira.voting.JiraVotingInput;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.testgap.query.TgaRequestUtils;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.jspecify.annotations.NonNull;

class JiraVotingInputCalculator {
    private final IndexLayer indexLayer;
    private final IProjectId projectId;
    private final ProjectStorageSystem projectStorageSystem;
    private final Logger logger;

    public JiraVotingInputCalculator(@NonNull IndexLayer indexLayer, @NonNull IProjectId projectId, @NonNull Logger logger) throws StorageException {
        this.indexLayer = indexLayer;
        this.projectId = projectId;
        this.projectStorageSystem = indexLayer.openProjectStorageSystem(projectId);
        this.logger = logger;
    }

    public Map<TeamscaleIssueId, JiraVotingInput> calculateVotingInput(CommitDescriptor schedulingCommit, Collection<TeamscaleIssueId> issueIds, ExtendedJiraIssueUpdateConfiguration jiraIssueUpdateConfiguration, VerifyNotCancelledCallback verifyNotCancelledCallback) throws StorageException, ExecutionCanceledException {
        HashMap<TeamscaleIssueId, JiraVotingInput> jiraVotingInputs = new HashMap<TeamscaleIssueId, JiraVotingInput>();
        RepositoryCommitIssueMappingIndex mappingIndex = (RepositoryCommitIssueMappingIndex)this.projectStorageSystem.openProjectIndex(RepositoryCommitIssueMappingIndex.class, null);
        for (TeamscaleIssueId issueId : issueIds) {
            verifyNotCancelledCallback.verifyNotCancelled();
            Optional<String> branch = JiraVotingInputCalculator.getBlacklistingBranchName(issueId, mappingIndex, schedulingCommit);
            if (branch.isEmpty()) {
                this.logger.error("Cannot get branch name for issue {}. Skipping. This should not happen. Please report to CQSE.", (Object)issueId);
                continue;
            }
            Optional<FindingChurnList> issueFindingChurn = this.computeIssueFindingChurn(issueId, jiraIssueUpdateConfiguration.getCategories(), mappingIndex, branch.get(), jiraIssueUpdateConfiguration.shouldHideResolvedFindings());
            Optional<Pair<Double, Boolean>> issueTestGapRatio = this.computeIssueTgaRatio(issueId, jiraIssueUpdateConfiguration.getCategories(), jiraIssueUpdateConfiguration.getTgaBranchConfig(), schedulingCommit);
            jiraVotingInputs.put(issueId, new JiraVotingInput(issueId, issueFindingChurn, issueTestGapRatio));
        }
        return jiraVotingInputs;
    }

    private Optional<FindingChurnList> computeIssueFindingChurn(TeamscaleIssueId issueId, Set<EJiraIssueUpdateCategory> categories, RepositoryCommitIssueMappingIndex mappingIndex, String branch, boolean hideResolvedFindings) throws StorageException {
        if (!categories.contains(EJiraIssueUpdateCategory.FINDINGS_BALANCE)) {
            return Optional.empty();
        }
        Optional<FindingChurnList> issueFindingChurn = FindingsServiceUtils.getBlacklistAwareFindingChurnForIssue(this.projectStorageSystem, issueId, branch, mappingIndex, hideResolvedFindings);
        if (issueFindingChurn.isEmpty()) {
            this.logger.info("Finding churn data for issue '{}' not available. Skipping. ({}).", (Object)issueId, (Object)this.getClass().getName());
        }
        return issueFindingChurn;
    }

    private Optional<Pair<Double, Boolean>> computeIssueTgaRatio(TeamscaleIssueId issueId, Set<EJiraIssueUpdateCategory> categories, JiraIssueUpdateTgaBranchConfiguration tgaBranchConfig, CommitDescriptor schedulingCommit) throws StorageException {
        if (!categories.contains(EJiraIssueUpdateCategory.TGA_COVERAGE)) {
            return Optional.empty();
        }
        boolean autoSelectBranch = tgaBranchConfig.isAutoSelectBranch();
        String tgaBranch = tgaBranchConfig.getBranchName();
        if (!autoSelectBranch && tgaBranch != null && !this.isBranchPresent(tgaBranch)) {
            this.logger.error("Test gap data for issue '{}' cannot be obtained because the branch '{}' (explicitly configured as TGA branch in the Jira connector settings) does not exist. Skipping. ({})", (Object)issueId, (Object)tgaBranch, (Object)this.getClass().getName());
            return Optional.empty();
        }
        Optional<Pair<Double, Boolean>> issueTestGapRatio = TgaRequestUtils.calculateTestGapRatioForIssue(issueId, this.indexLayer, this.projectId, autoSelectBranch, tgaBranch, JiraVotingInputCalculator.getEndCommitTimestamp(schedulingCommit));
        if (issueTestGapRatio.isEmpty()) {
            Object message = "Test gap data for issue '{}' not available on ";
            message = autoSelectBranch || tgaBranch == null ? (String)message + "auto-selected branch" : (String)message + "branch '" + tgaBranch + "' (explicitly configured as TGA branch in the Jira connector settings)";
            message = (String)message + ". Skipping. ({}).";
            this.logger.info((String)message, (Object)issueId, (Object)this.getClass().getName());
        }
        return issueTestGapRatio;
    }

    @VisibleForTesting
    boolean isBranchPresent(String branchName) throws StorageException {
        ProjectRepositoryChangeIndex projectRepositoryChangeIndex = (ProjectRepositoryChangeIndex)this.projectStorageSystem.openProjectIndex(ProjectRepositoryChangeIndex.class, null);
        ProjectRepositoryChangeIndex.ProjectRepositoryStatus repositoryStatus = projectRepositoryChangeIndex.getRepositoryStatus();
        return repositoryStatus.getNonPrecommitBranchNames().contains(branchName);
    }

    @VisibleForTesting
    static Optional<String> getBlacklistingBranchName(TeamscaleIssueId issueId, RepositoryCommitIssueMappingIndex mappingIndex, CommitDescriptor schedulingCommit) throws StorageException {
        if (schedulingCommit != null) {
            return Optional.of(Objects.requireNonNull(schedulingCommit).getBranchName());
        }
        return mappingIndex.getFirstAndLastCommitForIssue(issueId).map(firstLastCommit -> firstLastCommit.lastCommit.getBranchName());
    }

    @VisibleForTesting
    static long getEndCommitTimestamp(CommitDescriptor schedulingCommit) {
        if (schedulingCommit == null) {
            return Long.MAX_VALUE;
        }
        return schedulingCommit.getTimestamp();
    }

    @FunctionalInterface
    static interface VerifyNotCancelledCallback {
        public void verifyNotCancelled() throws ExecutionCanceledException;
    }
}

