/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.updater;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.issues.IIssueHistoryIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.updater.IssueTrackerContentUpdaterBase;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.List;
import java.util.function.Function;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS, EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class IssueIndexUpdateTrigger<T extends TeamscaleIssue>
extends IssueTrackerContentUpdaterBase<T> {
    public static final String WORK_ITEM_HISTORY_INDEX_PLACEHOLDER = "<workItemHistoryIndexNamePlaceholder>";
    @IndexAccess(indexName="<workItemIndexNamePlaceholder>", value=EIndexAccessMode.READ_WRITE)
    private IssueIndexBase<T> workItemIndex;
    @IndexAccess(indexName="<workItemHistoryIndexNamePlaceholder>", value=EIndexAccessMode.READ_WRITE)
    private IIssueHistoryIndex<T> historyIndex;

    @Override
    protected void handleWorkItemUpdates(List<T> updatedItems, List<TeamscaleIssueId> deletedItemIds) throws StorageException {
        long timestamp = this.getSchedulingCommit().getTimestamp();
        new IssueIndexUpdater<T>(this.workItemIndex, this.historyIndex, this.getConnectorIdentifier()).updateIndices(updatedItems, deletedItemIds, timestamp);
    }

    public static class IssueIndexUpdater<T extends TeamscaleIssue> {
        private final IssueIndexBase<T> workItemIndex;
        private final IIssueHistoryIndex<T> historyIndex;
        private final String connectorId;

        public IssueIndexUpdater(IssueIndexBase<T> workItemIndex, IIssueHistoryIndex<T> historyIndex, String connectorId) {
            this.workItemIndex = workItemIndex;
            this.historyIndex = historyIndex;
            this.connectorId = connectorId;
        }

        public void updateIndices(List<T> updatedItems, List<TeamscaleIssueId> deletedItemIds, long timestamp) throws StorageException {
            if (!deletedItemIds.isEmpty()) {
                this.historyIndex.remove(deletedItemIds, timestamp);
                this.workItemIndex.removeIssues(deletedItemIds);
            }
            if (!updatedItems.isEmpty()) {
                this.workItemIndex.setIssues(updatedItems);
                PairList itemsWithTimestamp = (PairList)updatedItems.stream().collect(PairList.toPairList(ignored -> timestamp, Function.identity()));
                this.historyIndex.store(itemsWithTimestamp);
            }
            this.workItemIndex.setLastChange(this.connectorId, timestamp);
        }
    }
}

