/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass
public class FirstLastCommit
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final CommitDescriptor firstCommit;
    public final CommitDescriptor lastCommit;

    public FirstLastCommit(@NonNull CommitDescriptor firstCommit, @NonNull CommitDescriptor lastCommit) {
        CCSMAssert.isTrue((firstCommit.getTimestamp() <= lastCommit.getTimestamp() ? 1 : 0) != 0, (String)"First commit cannot be older than last commit");
        this.firstCommit = firstCommit;
        this.lastCommit = lastCommit;
    }

    public static FirstLastCommit extractFromList(Collection<CommitDescriptor> commits) {
        if (commits.isEmpty()) {
            return null;
        }
        TreeSet<CommitDescriptor> sortedCommits = new TreeSet<CommitDescriptor>(commits);
        return new FirstLastCommit((CommitDescriptor)sortedCommits.first(), (CommitDescriptor)sortedCommits.last());
    }

    public int hashCode() {
        return Objects.hash(this.firstCommit, this.lastCommit);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FirstLastCommit)) {
            return false;
        }
        FirstLastCommit other = (FirstLastCommit)obj;
        return Objects.equals(this.firstCommit, other.firstCommit) && Objects.equals(this.lastCommit, other.lastCommit);
    }

    public String toString() {
        return "[FirstLastCommit] First: " + this.firstCommit.toString() + ", last: " + this.lastCommit.toString();
    }
}

