/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.index.repository.FirstLastCommit;
import com.teamscale.index.repository.RepositoryCommitMappingIndexBase;
import com.teamscale.wia.TeamscaleIssueId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Index(name="repository-commit-by-issue", options={EStorageOption.NO_ROLLBACK}, valueClasses={FirstLastCommit.class})
public class RepositoryCommitIssueMappingIndex
extends RepositoryCommitMappingIndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "repository-commit-by-issue";
    private static final byte[] FIRST_LAST_COMMIT_KEY_PREFIX = new byte[]{102};

    public RepositoryCommitIssueMappingIndex(IStore store) {
        super(store);
    }

    private static byte[] makeFirstLastCommitKey(TeamscaleIssueId id) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{FIRST_LAST_COMMIT_KEY_PREFIX, StringUtils.stringToBytes((String)id.getInternalId())});
    }

    public List<CommitDescriptor> getCommitsForIssue(TeamscaleIssueId issue) throws StorageException {
        return this.getCommitsForId(issue.getInternalId());
    }

    public SetMap<TeamscaleIssueId, CommitDescriptor> getCommitsForIssues(List<TeamscaleIssueId> issues) throws StorageException {
        return this.getCommitsForIds(CollectionUtils.map(issues, TeamscaleIssueId::getInternalId)).mapKeys(TeamscaleIssueId::fromInternalId);
    }

    public @Nullable List<TeamscaleIssueId> getIssuesForCommit(CommitDescriptor commit) throws StorageException {
        List<String> idsForCommit = this.getIdsForCommit(commit);
        return RepositoryCommitIssueMappingIndex.convertToTeamscaleIssueId(idsForCommit);
    }

    private static @Nullable List<TeamscaleIssueId> convertToTeamscaleIssueId(List<String> idsForCommit) {
        if (idsForCommit == null) {
            return null;
        }
        return CollectionUtils.map(idsForCommit, TeamscaleIssueId::fromInternalId);
    }

    public List<List<TeamscaleIssueId>> getIssuesForCommits(List<CommitDescriptor> commits) throws StorageException {
        return CollectionUtils.map(this.getIdsForCommits(commits), RepositoryCommitIssueMappingIndex::convertToTeamscaleIssueId);
    }

    public void storeFirstAndLastCommitForIssues(Map<TeamscaleIssueId, FirstLastCommit> issueCommitMap) throws StorageException {
        PairList values = new PairList();
        for (Map.Entry<TeamscaleIssueId, FirstLastCommit> entry : issueCommitMap.entrySet()) {
            values.add((Object)RepositoryCommitIssueMappingIndex.makeFirstLastCommitKey(entry.getKey()), (Object)StorageUtils.serialize((Serializable)entry.getValue()));
        }
        this.store.put(values);
    }

    public Optional<FirstLastCommit> getFirstAndLastCommitForIssue(TeamscaleIssueId issueId) throws StorageException {
        return Optional.ofNullable(this.getFirstAndLastCommitsForIssues(Collections.singletonList(issueId)).get(0));
    }

    public List<FirstLastCommit> getFirstAndLastCommitsForIssues(List<TeamscaleIssueId> issueIds) throws StorageException {
        List keys = CollectionUtils.map(issueIds, RepositoryCommitIssueMappingIndex::makeFirstLastCommitKey);
        List rawValues = this.store.get(keys);
        ArrayList<FirstLastCommit> firstAndLastCommits = new ArrayList<FirstLastCommit>();
        for (byte[] value : rawValues) {
            firstAndLastCommits.add((FirstLastCommit)StorageUtils.deserialize((byte[])value));
        }
        return firstAndLastCommits;
    }

    public void addRelations(SetMap<CommitDescriptor, TeamscaleIssueId> commitsToIssueIds) throws StorageException {
        super.addValues((SetMap<CommitDescriptor, String>)commitsToIssueIds.mapValues(TeamscaleIssueId::getInternalId));
    }
}

