/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.artifactory;

import com.google.common.base.Preconditions;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.artifact_store.ArtifactStoreUtils;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryRepositoryInfo;
import com.teamscale.index.repository.artifact_store.artifactory.SimpleArtifactoryClient;
import com.teamscale.index.repository.retrievers.IBranchRetriever;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.jspecify.annotations.Nullable;

public class ArtifactoryBranchRetriever
implements IBranchRetriever {
    private final Logger interactionLogger;

    public ArtifactoryBranchRetriever(Logger interactionLogger) {
        this.interactionLogger = interactionLogger;
    }

    @Override
    public Set<String> fetchBranches(boolean projectExists, String username, @Nullable ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws RepositoryException, ProjectConfigurationException {
        Preconditions.checkArgument((credentials != null ? 1 : 0) != 0);
        String publicContextPath = connectorConfiguration.getOptionValue("Public Context Path");
        SimpleArtifactoryClient client = new SimpleArtifactoryClient(credentials, publicContextPath, this.interactionLogger);
        ArtifactoryRepositoryInfo info = ArtifactStoreUtils.createArtifactoryRepositoryInfo(connectorConfiguration, null);
        return client.fetchBranches(info);
    }
}

