/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.scm_manager.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class ScmManagerPullRequests {

    public static class PullRequest {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="source")
        private String sourceBranch;
        @JsonProperty(value="target")
        private String targetBranch;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="sourceRevision")
        private String sourceRevision;
        @JsonProperty(value="targetRevision")
        private String targetRevision;
        @JsonProperty(value="creationDate")
        private String creationDate;
        @JsonProperty(value="lastModified")
        private String lastModified;

        public String getTitle() {
            return PullRequest.fixEncoding(this.title);
        }

        public String getId() {
            return this.id;
        }

        public String getSourceBranch() {
            return PullRequest.fixEncoding(this.sourceBranch);
        }

        public String getTargetBranch() {
            return PullRequest.fixEncoding(this.targetBranch);
        }

        public String getStatus() {
            return this.status;
        }

        public String getSourceRevision() {
            return this.sourceRevision;
        }

        public String getTargetRevision() {
            return this.targetRevision;
        }

        public String getCreationDate() {
            return this.creationDate;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        private static String fixEncoding(String input) {
            return new String(input.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
    }

    private static class EmbeddedPullRequests {
        @JsonProperty(value="pullRequests")
        private PullRequest[] pullRequests;

        private EmbeddedPullRequests() {
        }
    }

    public static class PullRequests {
        @JsonProperty(value="_embedded")
        private EmbeddedPullRequests embeddedPullRequests;

        public List<PullRequest> getPullRequests() {
            return Arrays.asList(this.embeddedPullRequests.pullRequests);
        }
    }
}

